/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.core;

import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.core.CachePolicy;
import io.github.douira.glsl_transformer.core.ConfigurableTransformation;
import io.github.douira.glsl_transformer.core.SearchTerminals;
import io.github.douira.glsl_transformer.core.target.HandlerTarget;
import io.github.douira.glsl_transformer.core.target.ParsedReplaceTarget;
import io.github.douira.glsl_transformer.core.target.TerminalReplaceTarget;
import io.github.douira.glsl_transformer.core.target.WrapThrowTarget;
import io.github.douira.glsl_transformer.transform.ActivatableLifecycleUser;
import io.github.douira.glsl_transformer.transform.InjectionPoint;
import io.github.douira.glsl_transformer.transform.JobParameters;
import io.github.douira.glsl_transformer.transform.RunPhase;
import io.github.douira.glsl_transformer.tree.ExtendedContext;
import io.github.douira.glsl_transformer.tree.TreeMember;
import io.github.douira.glsl_transformer.util.CompatUtil;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;

public class WrapIdentifier<T extends JobParameters>
extends ConfigurableTransformation<T> {
    private Supplier<ActivatableLifecycleUser<T>> wrapResultDetector = this.once(this::getWrapResultDetector);
    private Supplier<String> detectionResult = this.once(this::parsedReplacement);
    private Supplier<String> parsedReplacement = this.once(this::getParsedReplacement);
    private Supplier<Function<GLSLParser, ExtendedContext>> parseMethod = this.once(this::getParseMethod);
    private Supplier<ActivatableLifecycleUser<T>> wrappingReplacer = this.once(this::getWrappingReplacer);
    private Supplier<Collection<HandlerTarget<T>>> wrapHandlerTargets = this.once(this::getWrapHandlerTargets);
    private Supplier<String> wrapTarget = this.once(this::getWrapTarget);
    private Supplier<ActivatableLifecycleUser<T>> injector = this.once(this::getInjector);
    private Supplier<InjectionPoint> injectionLocation = this.once(this::getInjectionLocation);
    private Supplier<String> injectionExternalDeclaration = this.once(this::getInjectionExternalDeclaration);

    @Override
    protected void setupGraph() {
        this.chainDependent(this.getWrapResultDetector());
        this.chainDependent(this.getWrappingReplacer());
        this.chainDependent(this.getInjector());
    }

    protected ActivatableLifecycleUser<T> getWrapResultDetector() {
        return new SearchTerminals().singleTarget(new WrapThrowTarget<T>(){

            @Override
            protected String getWrapResult() {
                return WrapIdentifier.this.detectionResult();
            }
        });
    }

    protected String getDetectionResult() {
        return this.parsedReplacement();
    }

    protected String getParsedReplacement() {
        throw new IllegalStateException("No parsed replacement is set");
    }

    protected Function<GLSLParser, ExtendedContext> getParseMethod() {
        return GLSLParser::expression;
    }

    protected ActivatableLifecycleUser<T> getWrappingReplacer() {
        return new SearchTerminals<T>(){

            @Override
            protected Collection<HandlerTarget<T>> getTargets() {
                return WrapIdentifier.this.wrapHandlerTargets();
            }
        };
    }

    protected Collection<HandlerTarget<T>> getWrapHandlerTargets() {
        try {
            this.parsedReplacement();
            return CompatUtil.listOf(new ParsedReplaceTarget<T>(){

                @Override
                public String getNeedle() {
                    return WrapIdentifier.this.wrapTarget();
                }

                @Override
                protected String getNewContent(TreeMember node, String match) {
                    return WrapIdentifier.this.parsedReplacement();
                }

                @Override
                protected Function<GLSLParser, ExtendedContext> getParseMethod(TreeMember node, String match) {
                    return WrapIdentifier.this.parseMethod();
                }
            });
        }
        catch (Exception e) {
            return CompatUtil.listOf(new TerminalReplaceTarget<T>(){

                @Override
                public String getNeedle() {
                    return WrapIdentifier.this.wrapTarget();
                }

                @Override
                protected String getTerminalContent() {
                    return WrapIdentifier.this.detectionResult();
                }
            });
        }
    }

    protected String getWrapTarget() {
        throw new IllegalStateException("No wrap target is set");
    }

    protected ActivatableLifecycleUser<T> getInjector() {
        return new RunPhase<T>(){

            @Override
            protected void run(GLSLParser.TranslationUnitContext ctx) {
                this.injectExternalDeclaration(WrapIdentifier.this.injectionLocation(), WrapIdentifier.this.injectionExternalDeclaration());
            }
        };
    }

    protected InjectionPoint getInjectionLocation() {
        return InjectionPoint.BEFORE_DECLARATIONS;
    }

    protected String getInjectionExternalDeclaration() {
        throw new IllegalStateException("No injection external declaration is set");
    }

    public WrapIdentifier<T> wrapResultDetector(ActivatableLifecycleUser<T> wrapResultDetector) {
        this.wrapResultDetector = this.swapSupplier(this.wrapResultDetector, wrapResultDetector);
        return this;
    }

    public WrapIdentifier<T> detectionResult(String detectionResult) {
        this.detectionResult = this.swapSupplier(this.detectionResult, detectionResult);
        return this;
    }

    public WrapIdentifier<T> parsedReplacement(String parsedReplacement) {
        this.parsedReplacement = this.swapSupplier(this.parsedReplacement, parsedReplacement);
        return this;
    }

    public WrapIdentifier<T> parseMethod(Function<GLSLParser, ExtendedContext> parseMethod) {
        this.parseMethod = this.swapSupplier(this.parseMethod, parseMethod);
        return this;
    }

    public WrapIdentifier<T> wrappingReplacer(ActivatableLifecycleUser<T> wrappingReplacer) {
        this.wrappingReplacer = this.swapSupplier(this.wrappingReplacer, wrappingReplacer);
        return this;
    }

    public WrapIdentifier<T> wrapHandlerTargets(Collection<HandlerTarget<T>> wrapHandlerTargets) {
        this.wrapHandlerTargets = this.swapSupplier(this.wrapHandlerTargets, wrapHandlerTargets);
        return this;
    }

    public WrapIdentifier<T> wrapTarget(String wrapTarget) {
        this.wrapTarget = this.swapSupplier(this.wrapTarget, wrapTarget);
        return this;
    }

    public WrapIdentifier<T> injector(ActivatableLifecycleUser<T> injector) {
        this.injector = this.swapSupplier(this.injector, injector);
        return this;
    }

    public WrapIdentifier<T> injectionLocation(InjectionPoint injectionLocation) {
        this.injectionLocation = this.swapSupplier(this.injectionLocation, injectionLocation);
        return this;
    }

    public WrapIdentifier<T> injectionExternalDeclaration(String injectionExternalDeclaration) {
        this.injectionExternalDeclaration = this.swapSupplier(this.injectionExternalDeclaration, injectionExternalDeclaration);
        return this;
    }

    public WrapIdentifier<T> wrapResultDetector(Supplier<ActivatableLifecycleUser<T>> wrapResultDetector) {
        this.wrapResultDetector = this.swapSupplier(this.wrapResultDetector, wrapResultDetector);
        return this;
    }

    public WrapIdentifier<T> detectionResult(Supplier<String> detectionResult) {
        this.detectionResult = this.swapSupplier(this.detectionResult, detectionResult);
        return this;
    }

    public WrapIdentifier<T> parsedReplacement(Supplier<String> parsedReplacement) {
        this.parsedReplacement = this.swapSupplier(this.parsedReplacement, parsedReplacement);
        return this;
    }

    public WrapIdentifier<T> parseMethod(Supplier<Function<GLSLParser, ExtendedContext>> parseMethod) {
        this.parseMethod = this.swapSupplier(this.parseMethod, parseMethod);
        return this;
    }

    public WrapIdentifier<T> wrappingReplacer(Supplier<ActivatableLifecycleUser<T>> wrappingReplacer) {
        this.wrappingReplacer = this.swapSupplier(this.wrappingReplacer, wrappingReplacer);
        return this;
    }

    public WrapIdentifier<T> wrapHandlerTargets(Supplier<Collection<HandlerTarget<T>>> wrapHandlerTargets) {
        this.wrapHandlerTargets = this.swapSupplier(this.wrapHandlerTargets, wrapHandlerTargets);
        return this;
    }

    public WrapIdentifier<T> wrapTarget(Supplier<String> wrapTarget) {
        this.wrapTarget = this.swapSupplier(this.wrapTarget, wrapTarget);
        return this;
    }

    public WrapIdentifier<T> injector(Supplier<ActivatableLifecycleUser<T>> injector) {
        this.injector = this.swapSupplier(this.injector, injector);
        return this;
    }

    public WrapIdentifier<T> injectionLocation(Supplier<InjectionPoint> injectionLocation) {
        this.injectionLocation = this.swapSupplier(this.injectionLocation, injectionLocation);
        return this;
    }

    public WrapIdentifier<T> injectionExternalDeclaration(Supplier<String> injectionExternalDeclaration) {
        this.injectionExternalDeclaration = this.swapSupplier(this.injectionExternalDeclaration, injectionExternalDeclaration);
        return this;
    }

    public WrapIdentifier<T> wrapResultDetector(CachePolicy newPolicy) {
        this.wrapResultDetector = this.swapPolicy(this.wrapResultDetector, newPolicy);
        return this;
    }

    public WrapIdentifier<T> detectionResult(CachePolicy newPolicy) {
        this.detectionResult = this.swapPolicy(this.detectionResult, newPolicy);
        return this;
    }

    public WrapIdentifier<T> parsedReplacement(CachePolicy newPolicy) {
        this.parsedReplacement = this.swapPolicy(this.parsedReplacement, newPolicy);
        return this;
    }

    public WrapIdentifier<T> parseMethod(CachePolicy newPolicy) {
        this.parseMethod = this.swapPolicy(this.parseMethod, newPolicy);
        return this;
    }

    public WrapIdentifier<T> wrappingReplacer(CachePolicy newPolicy) {
        this.wrappingReplacer = this.swapPolicy(this.wrappingReplacer, newPolicy);
        return this;
    }

    public WrapIdentifier<T> wrapHandlerTargets(CachePolicy newPolicy) {
        this.wrapHandlerTargets = this.swapPolicy(this.wrapHandlerTargets, newPolicy);
        return this;
    }

    public WrapIdentifier<T> wrapTarget(CachePolicy newPolicy) {
        this.wrapTarget = this.swapPolicy(this.wrapTarget, newPolicy);
        return this;
    }

    public WrapIdentifier<T> injector(CachePolicy newPolicy) {
        this.injector = this.swapPolicy(this.injector, newPolicy);
        return this;
    }

    public WrapIdentifier<T> injectionLocation(CachePolicy newPolicy) {
        this.injectionLocation = this.swapPolicy(this.injectionLocation, newPolicy);
        return this;
    }

    public WrapIdentifier<T> injectionExternalDeclaration(CachePolicy newPolicy) {
        this.injectionExternalDeclaration = this.swapPolicy(this.injectionExternalDeclaration, newPolicy);
        return this;
    }

    protected final ActivatableLifecycleUser<T> wrapResultDetector() {
        return this.wrapResultDetector.get().activation(this::isActive);
    }

    protected final String detectionResult() {
        return this.detectionResult.get();
    }

    protected final String parsedReplacement() {
        return this.parsedReplacement.get();
    }

    protected final Function<GLSLParser, ExtendedContext> parseMethod() {
        return this.parseMethod.get();
    }

    protected final ActivatableLifecycleUser<T> wrappingReplacer() {
        return this.wrappingReplacer.get().activation(this::isActive);
    }

    protected final Collection<HandlerTarget<T>> wrapHandlerTargets() {
        return this.wrapHandlerTargets.get();
    }

    protected final String wrapTarget() {
        return this.wrapTarget.get();
    }

    protected final ActivatableLifecycleUser<T> injector() {
        return this.injector.get().activation(this::isActive);
    }

    protected final InjectionPoint injectionLocation() {
        return this.injectionLocation.get();
    }

    protected final String injectionExternalDeclaration() {
        return this.injectionExternalDeclaration.get();
    }
}

