/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.core;

import io.github.douira.glsl_transformer.core.CachePolicy;
import java.util.function.Supplier;

public class CachingSupplier<V>
implements Supplier<V> {
    private V cachedValue;
    private final CachePolicy cachePolicy;
    private final Supplier<V> generator;

    protected CachingSupplier(CachePolicy cachePolicy, Supplier<V> generator) {
        this.cachePolicy = cachePolicy;
        this.generator = generator;
    }

    @Override
    public V get() {
        if (this.cachedValue == null || this.cachePolicy == CachePolicy.ALWAYS) {
            this.cachedValue = this.generator.get();
        }
        return this.cachedValue;
    }

    public void invalidate(CachePolicy fulfilledPolicy) {
        if (fulfilledPolicy.ordinal() <= this.cachePolicy.ordinal()) {
            this.cachedValue = null;
        }
    }

    Supplier<V> getSupplierWithPolicy(CachePolicy cachePolicy) {
        if (this.cachePolicy == cachePolicy) {
            return this;
        }
        return CachingSupplier.of(cachePolicy, this.generator);
    }

    public static <V> Supplier<V> of(CachePolicy cachePolicy, Supplier<V> generator) {
        return cachePolicy == CachePolicy.ALWAYS ? generator : new CachingSupplier<V>(cachePolicy, generator);
    }
}

