/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.traversal;

import io.github.douira.glsl_transformer.traversal.PartialParseTreeListener;
import io.github.douira.glsl_transformer.tree.ExtendedContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.TerminalNode;

public class ProxyParseTreeListener
implements PartialParseTreeListener {
    private Collection<PartialParseTreeListener> listeners;
    private Iterator<PartialParseTreeListener> listenerIterator;

    public ProxyParseTreeListener(Collection<PartialParseTreeListener> listeners) {
        this.setListeners(listeners);
    }

    public void add(PartialParseTreeListener listener) {
        this.getListeners().add(listener);
    }

    public boolean remove(PartialParseTreeListener listener) {
        return this.getListeners().remove(listener);
    }

    private Collection<PartialParseTreeListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(Collection<PartialParseTreeListener> listeners) {
        this.listeners = Optional.ofNullable(listeners).orElseGet(ArrayList::new);
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void removeCurrentListener() {
        this.listenerIterator.remove();
    }

    private void iterateListeners(Consumer<PartialParseTreeListener> consumer) {
        this.listenerIterator = this.getListeners().iterator();
        while (this.listenerIterator.hasNext()) {
            consumer.accept(this.listenerIterator.next());
        }
        this.listenerIterator = null;
    }

    @Override
    public boolean isDeepEnough(ExtendedContext node) {
        for (PartialParseTreeListener listener : this.getListeners()) {
            if (listener.isDeepEnough(node)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFinished() {
        if (this.isEmpty()) {
            return true;
        }
        for (PartialParseTreeListener listener : this.getListeners()) {
            if (listener.isFinished()) continue;
            return false;
        }
        return true;
    }

    public void enterEveryRule(ParserRuleContext ctx) {
        this.iterateListeners(listener -> {
            listener.enterEveryRule(ctx);
            ctx.enterRule((ParseTreeListener)listener);
        });
    }

    public void exitEveryRule(ParserRuleContext ctx) {
        this.iterateListeners(listener -> {
            ctx.exitRule((ParseTreeListener)listener);
            listener.exitEveryRule(ctx);
        });
    }

    public void visitErrorNode(ErrorNode node) {
        this.iterateListeners(listener -> listener.visitErrorNode(node));
    }

    public void visitTerminal(TerminalNode node) {
        this.iterateListeners(listener -> listener.visitTerminal(node));
    }
}

