/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.transform;

import io.github.douira.glsl_transformer.GLSLLexer;
import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.transform.JobParameters;
import io.github.douira.glsl_transformer.transform.LifecycleUser;
import io.github.douira.glsl_transformer.transform.Node;
import io.github.douira.glsl_transformer.transform.Transformation;
import io.github.douira.glsl_transformer.transform.TransformationPhase;
import io.github.douira.glsl_transformer.traversal.DynamicParseTreeWalker;
import io.github.douira.glsl_transformer.traversal.PartialParseTreeListener;
import io.github.douira.glsl_transformer.traversal.ProxyParseTreeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.antlr.v4.runtime.BufferedTokenStream;

public abstract class ExecutionPlanner<T extends JobParameters> {
    private Map<T, ExecutionPlan> executionPlanCache = new HashMap<T, ExecutionPlan>();
    private final Transformation<T> rootTransformation = new Transformation();
    private GLSLParser.TranslationUnitContext rootNode;
    private ProxyParseTreeListener proxyListener;
    private T jobParameters;

    public abstract GLSLParser getParser();

    public abstract GLSLLexer getLexer();

    T getJobParameters() {
        return this.jobParameters;
    }

    public <R> R withJobParameters(T parameters, Supplier<R> run) {
        this.jobParameters = parameters;
        R value = run.get();
        this.jobParameters = null;
        return value;
    }

    public void withJobParameters(T parameters, Runnable run) {
        this.withJobParameters(parameters, () -> {
            run.run();
            return null;
        });
    }

    GLSLParser.TranslationUnitContext getRootNode() {
        return this.rootNode;
    }

    public void addConcurrent(LifecycleUser<T> rootDependency) {
        this.rootTransformation.addRootDependency(rootDependency);
    }

    public Transformation<T> getRootTransformation() {
        return this.rootTransformation;
    }

    void removeCurrentPhaseFromWalk() {
        this.proxyListener.removeCurrentListener();
    }

    private ExecutionPlan getExecutionPlan() {
        T jobParameters = this.getJobParameters();
        ExecutionPlan plan = this.executionPlanCache.get(jobParameters);
        if (plan == null) {
            plan = new ExecutionPlan();
            plan.planExecution(this.rootTransformation);
            this.executionPlanCache.put(jobParameters, plan);
        }
        return plan;
    }

    public void planExecutionFor(T parameters) {
        this.withJobParameters(parameters, this::getExecutionPlan);
    }

    private void execute(GLSLParser.TranslationUnitContext ctx) {
        ExecutionPlan plan = this.getExecutionPlan();
        this.rootNode = ctx;
        plan.execute(this);
        this.rootNode = null;
    }

    protected void transformTree(GLSLParser.TranslationUnitContext ctx, BufferedTokenStream tokenStream) {
        ctx.makeLocalRoot(tokenStream);
        this.execute(ctx);
    }

    private class ExecutionPlan {
        List<ExecutionLevel<T>> executionLevels;
        Collection<Transformation<T>> transformations;

        private ExecutionPlan() {
        }

        void planExecution(Transformation<T> rootTransformation) {
            HashSet transformationSet = new HashSet();
            HashSet dependenciesProcessed = new HashSet();
            HashMap endNodeMap = new HashMap();
            HashMap contentNodeMap = new HashMap();
            LinkedList collectQueue = new LinkedList();
            rootTransformation.setPlanner(ExecutionPlanner.this);
            rootTransformation.doGraphSetup();
            LabeledNode rootNode = new LabeledNode();
            collectQueue.add(new CollectEntry(new Node(rootTransformation), rootNode));
            while (!collectQueue.isEmpty()) {
                CollectEntry queueEntry = (CollectEntry)collectQueue.poll();
                Node node = queueEntry.nodeToProcess();
                LifecycleUser content = node.getContent();
                LabeledNode labeledNode = content == null ? Optional.ofNullable((LabeledNode)endNodeMap.get(node)).orElseGet(LabeledNode::new) : Optional.ofNullable((LabeledNode)contentNodeMap.get(content)).orElseGet(() -> {
                    LabeledNode newNode = new LabeledNode(content);
                    contentNodeMap.put(content, newNode);
                    return newNode;
                });
                queueEntry.dependent().linkDependency(labeledNode);
                if (dependenciesProcessed.contains(node)) continue;
                dependenciesProcessed.add(node);
                if (Transformation.class.isInstance(content)) {
                    Iterator transformation = (Transformation)content;
                    transformationSet.add(transformation);
                    Node node2 = ((Transformation)((Object)transformation)).getEndDepNode();
                    LabeledNode endLabeledNode = Optional.ofNullable((LabeledNode)endNodeMap.get(node2)).orElseGet(() -> {
                        LabeledNode newNode = new LabeledNode();
                        endNodeMap.put(endNode, newNode);
                        return newNode;
                    });
                    for (Node dependency : node.getDependencies()) {
                        collectQueue.add(new CollectEntry(dependency, endLabeledNode));
                    }
                    collectQueue.add(new CollectEntry(((Transformation)((Object)transformation)).getRootDepNode(), labeledNode));
                    continue;
                }
                for (Node node3 : node.getDependencies()) {
                    collectQueue.add(new CollectEntry(node3, labeledNode));
                }
            }
            this.transformations = new ArrayList();
            this.transformations.addAll(transformationSet);
            LinkedList dfsStack = new LinkedList();
            dfsStack.push(new DFSEntry(rootNode, true));
            ArrayList<LabeledNode> topoSort = new ArrayList<LabeledNode>();
            while (!dfsStack.isEmpty()) {
                if (dfsStack.size() > dependenciesProcessed.size() * 2) {
                    throw new AssertionError((Object)"The dependency graph could not be satisfied! There is may be a cycle in it or the root and end nodes are messed up. Check for cycles in the graph after construction and after resolving transformations. Also make sure there is a single end and a single (generated) root node.");
                }
                DFSEntry entry = (DFSEntry)dfsStack.pop();
                LabeledNode node = entry.node();
                if (entry.enter()) {
                    if (node.dfsFinished) continue;
                    dfsStack.push(new DFSEntry(node, false));
                    for (LabeledNode labeledNode : node.dependencies) {
                        dfsStack.push(new DFSEntry(labeledNode, true));
                    }
                    continue;
                }
                node.dfsFinished = true;
                topoSort.add(node);
            }
            this.executionLevels = new ArrayList();
            this.executionLevels.add(new ExecutionLevel());
            ((LabeledNode)topoSort.get((int)0)).executionLevelIndex = -1;
            for (LabeledNode node : topoSort) {
                for (LabeledNode labeledNode : node.dependencies) {
                    if (labeledNode.executionLevelIndex <= node.executionLevelIndex) continue;
                    node.executionLevelIndex = labeledNode.executionLevelIndex;
                }
                if (!TransformationPhase.class.isInstance(node.content)) continue;
                TransformationPhase phase = (TransformationPhase)node.content;
                if (phase.canWalk()) {
                    ++node.executionLevelIndex;
                    if (this.executionLevels.size() <= node.executionLevelIndex + 1) {
                        this.executionLevels.add(new ExecutionLevel());
                    }
                    this.executionLevels.get(node.executionLevelIndex + 1).walkPhases().add(phase);
                    continue;
                }
                this.executionLevels.get(node.executionLevelIndex + 1).nonWalkPhases.add(phase);
            }
        }

        void execute(ExecutionPlanner<T> planner) {
            for (Transformation transformation : this.transformations) {
                transformation.setPlanner(planner);
                transformation.initOnce();
                transformation.resetState();
            }
            for (ExecutionLevel executionLevel : this.executionLevels) {
                ExecutionPlanner.this.proxyListener = new ProxyParseTreeListener(new ArrayList<PartialParseTreeListener>());
                for (TransformationPhase walkPhase : executionLevel.walkPhases()) {
                    walkPhase.setPlanner(planner);
                    walkPhase.initOnce();
                    walkPhase.resetState();
                    if (!walkPhase.checkBeforeWalk(ExecutionPlanner.this.rootNode)) continue;
                    ExecutionPlanner.this.proxyListener.add(walkPhase);
                    walkPhase.resetWalkFinishState();
                }
                if (!ExecutionPlanner.this.proxyListener.isEmpty()) {
                    DynamicParseTreeWalker.DEFAULT.walk(ExecutionPlanner.this.proxyListener, ExecutionPlanner.this.rootNode);
                }
                for (TransformationPhase walkPhase : executionLevel.walkPhases()) {
                    walkPhase.runAfterWalk(ExecutionPlanner.this.rootNode);
                }
                for (TransformationPhase nonWalkPhase : executionLevel.nonWalkPhases()) {
                    nonWalkPhase.setPlanner(planner);
                    nonWalkPhase.initOnce();
                    nonWalkPhase.resetState();
                    nonWalkPhase.checkBeforeWalk(ExecutionPlanner.this.rootNode);
                    nonWalkPhase.runAfterWalk(ExecutionPlanner.this.rootNode);
                }
            }
            ExecutionPlanner.this.proxyListener = null;
        }

        static class LabeledNode<S extends JobParameters> {
            final LifecycleUser<S> content;
            Collection<LabeledNode<S>> dependencies = new HashSet<LabeledNode<S>>();
            Collection<LabeledNode<S>> dependents = new HashSet<LabeledNode<S>>();
            int executionLevelIndex = Integer.MIN_VALUE;
            boolean dfsFinished = false;

            LabeledNode(LifecycleUser<S> content) {
                this.content = content;
            }

            LabeledNode() {
                this.content = null;
            }

            void linkDependency(LabeledNode<S> dependency) {
                this.dependencies.add(dependency);
                dependency.dependents.add(this);
            }
        }

        static final class CollectEntry<S extends JobParameters> {
            private final Node<S> nodeToProcess;
            private final LabeledNode<S> dependent;

            CollectEntry(Node<S> nodeToProcess, LabeledNode<S> dependent) {
                this.nodeToProcess = nodeToProcess;
                this.dependent = dependent;
            }

            public String toString() {
                return "CollectEntry[" + "nodeToProcess=" + this.nodeToProcess + "," + "dependent=" + this.dependent + "]";
            }

            public int hashCode() {
                int result = 0;
                result = 31 * result + (this.nodeToProcess != null ? this.nodeToProcess.hashCode() : 0);
                result = 31 * result + (this.dependent != null ? this.dependent.hashCode() : 0);
                return result;
            }

            public final boolean equals(Object arg0) {
                if (this == arg0) {
                    return true;
                }
                if (arg0 == null) {
                    return false;
                }
                if (arg0.getClass() != this.getClass()) {
                    return false;
                }
                if (!Objects.equals(((CollectEntry)arg0).nodeToProcess, this.nodeToProcess)) {
                    return false;
                }
                return Objects.equals(((CollectEntry)arg0).dependent, this.dependent);
                {
                }
            }

            public Node<S> nodeToProcess() {
                return this.nodeToProcess;
            }

            public LabeledNode<S> dependent() {
                return this.dependent;
            }
        }

        static final class DFSEntry<S extends JobParameters> {
            private final LabeledNode<S> node;
            private final boolean enter;

            DFSEntry(LabeledNode<S> node, boolean enter) {
                this.node = node;
                this.enter = enter;
            }

            public String toString() {
                return "DFSEntry[" + "node=" + this.node + "," + "enter=" + this.enter + "]";
            }

            public int hashCode() {
                int result = 0;
                result = 31 * result + (this.node != null ? this.node.hashCode() : 0);
                result = 31 * result + (this.enter ? 1 : 0);
                return result;
            }

            public final boolean equals(Object arg0) {
                if (this == arg0) {
                    return true;
                }
                if (arg0 == null) {
                    return false;
                }
                if (arg0.getClass() != this.getClass()) {
                    return false;
                }
                if (!Objects.equals(((DFSEntry)arg0).node, this.node)) {
                    return false;
                }
                return ((DFSEntry)arg0).enter == this.enter;
                {
                }
            }

            public LabeledNode<S> node() {
                return this.node;
            }

            public boolean enter() {
                return this.enter;
            }
        }

        private static final class ExecutionLevel<S extends JobParameters> {
            private final Collection<TransformationPhase<S>> walkPhases;
            private final List<TransformationPhase<S>> nonWalkPhases;

            public ExecutionLevel() {
                this(new ArrayList<TransformationPhase<S>>(), new ArrayList<TransformationPhase<S>>());
            }

            private ExecutionLevel(Collection<TransformationPhase<S>> walkPhases, List<TransformationPhase<S>> nonWalkPhases) {
                this.walkPhases = walkPhases;
                this.nonWalkPhases = nonWalkPhases;
            }

            public String toString() {
                return "ExecutionLevel[" + "walkPhases=" + this.walkPhases + "," + "nonWalkPhases=" + this.nonWalkPhases + "]";
            }

            public int hashCode() {
                int result = 0;
                result = 31 * result + (this.walkPhases != null ? this.walkPhases.hashCode() : 0);
                result = 31 * result + (this.nonWalkPhases != null ? this.nonWalkPhases.hashCode() : 0);
                return result;
            }

            public final boolean equals(Object arg0) {
                if (this == arg0) {
                    return true;
                }
                if (arg0 == null) {
                    return false;
                }
                if (arg0.getClass() != this.getClass()) {
                    return false;
                }
                if (!Objects.equals(((ExecutionLevel)arg0).walkPhases, this.walkPhases)) {
                    return false;
                }
                return Objects.equals(((ExecutionLevel)arg0).nonWalkPhases, this.nonWalkPhases);
                {
                }
            }

            public Collection<TransformationPhase<S>> walkPhases() {
                return this.walkPhases;
            }

            public List<TransformationPhase<S>> nonWalkPhases() {
                return this.nonWalkPhases;
            }
        }
    }
}

