/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast;

import io.github.douira.glsl_transformer.ast.StringNode;

public class Directive
extends StringNode {
    private final Type type;

    public Directive(Type type, String content) {
        super(Directive.cleanContent(content));
        if (type == null) {
            throw new IllegalArgumentException("Non-null type must be used to construct a directive!");
        }
        if (type == Type.EMPTY) {
            throw new IllegalArgumentException("The EMPTY type may only be used with the corresponding constructor!");
        }
        this.type = type;
    }

    public Directive() {
        super("");
        this.type = Type.EMPTY;
    }

    private static String cleanContent(String content) {
        return content == null ? null : content.trim().replace("\n", "\\\n");
    }

    @Override
    protected String getPrinted() {
        if (this.type == Type.EMPTY) {
            return "#\n";
        }
        return ("#" + this.type.name().toLowerCase() + " " + this.getContent()).trim() + "\n";
    }

    public static enum Type {
        DEFINE,
        INCLUDE,
        UNDEF,
        IF,
        IFDEF,
        IFNDEF,
        ELSE,
        ELIF,
        ENDIF,
        ERROR,
        LINE,
        EMPTY;

    }
}

