/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.transform;

import io.github.douira.glsl_transformer.transform.LifecycleUser;
import io.github.douira.glsl_transformer.transform.LifecycleUserImpl;
import io.github.douira.glsl_transformer.transform.Node;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class Transformation<T>
extends LifecycleUserImpl<T> {
    private final Map<LifecycleUser<T>, Node<T>> contentNodes = new HashMap<LifecycleUser<T>, Node<T>>();
    private Node<T> rootNode = new Node();
    private Node<T> endNode = new Node();
    private Node<T> lastDependency = this.rootNode;
    private Node<T> lastDependent = this.endNode;

    public Transformation(LifecycleUser<T> content) {
        this.updateInternalLinks();
        this.addRootDependency(content);
    }

    public Transformation() {
        this.updateInternalLinks();
    }

    Node<T> getRootDepNode() {
        return this.rootNode;
    }

    Node<T> getEndDepNode() {
        return this.endNode;
    }

    private Node<T> getNode(LifecycleUser<T> content) {
        return Optional.ofNullable(this.contentNodes.get(content)).orElseGet(() -> {
            Node newNode = new Node(content);
            this.contentNodes.put(content, newNode);
            return newNode;
        });
    }

    private void updateInternalLinks() {
        this.rootNode.updateEndLink(this.endNode);
    }

    private void addDependency(Node<T> dependentNode, Node<T> dependencyNode) {
        if (dependencyNode == this.rootNode) {
            throw new Error("The root node may not be made a dependency. Use prependDependency for replacing the root node.");
        }
        if (dependentNode == this.endNode) {
            throw new Error("The end node may not be made a dependent. Use appendDependent for replacing the end node.");
        }
        dependentNode.addDependency(dependencyNode);
        this.lastDependent = dependentNode;
        this.lastDependency = dependencyNode;
        dependentNode.updateBothLinks(this.rootNode, this.endNode);
        dependencyNode.updateBothLinks(this.rootNode, this.endNode);
        this.updateInternalLinks();
    }

    private void addDependent(Node<T> dependencyNode, Node<T> dependentNode) {
        this.addDependency(dependentNode, dependencyNode);
    }

    public void addDependency(LifecycleUser<T> dependent, LifecycleUser<T> dependency) {
        this.addDependency(this.getNode(dependent), this.getNode(dependency));
    }

    public void addDependent(LifecycleUser<T> dependency, LifecycleUser<T> dependent) {
        this.addDependent(this.getNode(dependency), this.getNode(dependent));
    }

    public LifecycleUser<T> chainDependency(LifecycleUser<T> dependency) {
        this.addDependency(this.lastDependency, this.getNode(dependency));
        return dependency;
    }

    public LifecycleUser<T> chainDependent(LifecycleUser<T> dependent) {
        this.addDependent(this.lastDependent, this.getNode(dependent));
        return dependent;
    }

    public LifecycleUser<T> addRootDependency(LifecycleUser<T> dependency) {
        this.addDependency(this.rootNode, this.getNode(dependency));
        return dependency;
    }

    public LifecycleUser<T> addEndDependent(LifecycleUser<T> dependent) {
        this.addDependent(this.endNode, this.getNode(dependent));
        return dependent;
    }

    public LifecycleUser<T> appendDependent(LifecycleUser<T> newSoleEndDependent) {
        Node<T> soleEndDependency = this.endNode;
        this.endNode = new Node();
        soleEndDependency.setContent(newSoleEndDependent);
        this.contentNodes.put(newSoleEndDependent, soleEndDependency);
        soleEndDependency.addDependency(this.endNode);
        this.lastDependent = soleEndDependency;
        this.lastDependency = this.endNode;
        return newSoleEndDependent;
    }

    public LifecycleUser<T> prependDependency(LifecycleUser<T> newSoleRootDependency) {
        Node<T> soleRootDependency = this.rootNode;
        this.rootNode = new Node();
        soleRootDependency.setContent(newSoleRootDependency);
        this.contentNodes.put(newSoleRootDependency, soleRootDependency);
        this.rootNode.addDependency(soleRootDependency);
        this.lastDependent = this.rootNode;
        this.lastDependency = soleRootDependency;
        return newSoleRootDependency;
    }

    public LifecycleUser<T> chainConcurrentDependency(LifecycleUser<T> dependency) {
        this.addDependency(this.lastDependent, this.getNode(dependency));
        return dependency;
    }

    public LifecycleUser<T> chainConcurrentDependent(LifecycleUser<T> dependent) {
        this.addDependent(this.lastDependency, this.getNode(dependent));
        return dependent;
    }

    public LifecycleUser<T> chainConcurrentSibling(LifecycleUser<T> sibling) {
        Node<T> siblingNode = this.getNode(sibling);
        Node<T> lastDependencyLocal = this.lastDependency;
        this.addDependency(this.lastDependent, siblingNode);
        this.addDependent(lastDependencyLocal, siblingNode);
        return sibling;
    }
}

