/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.transform;

import io.github.douira.glsl_transformer.GLSLLexer;
import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.transform.DynamicParseTreeWalker;
import io.github.douira.glsl_transformer.transform.LifecycleUser;
import io.github.douira.glsl_transformer.transform.Node;
import io.github.douira.glsl_transformer.transform.PartialParseTreeListener;
import io.github.douira.glsl_transformer.transform.ProxyParseTreeListener;
import io.github.douira.glsl_transformer.transform.Transformation;
import io.github.douira.glsl_transformer.transform.TransformationPhase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.antlr.v4.runtime.BufferedTokenStream;

public abstract class ExecutionPlanner<T> {
    private List<Collection<TransformationPhase<T>>> executionLevels;
    private final Collection<Transformation<T>> transformations = new ArrayList<Transformation<T>>();
    private final Transformation<T> rootTransformation = new Transformation();
    private GLSLParser.TranslationUnitContext rootNode;
    private ProxyParseTreeListener proxyListener;
    private boolean finalized = false;
    private boolean initialized = false;

    public abstract GLSLParser getParser();

    public abstract GLSLLexer getLexer();

    abstract T getJobParameters();

    GLSLParser.TranslationUnitContext getRootNode() {
        return this.rootNode;
    }

    public void addConcurrent(LifecycleUser<T> rootDependency) {
        this.rootTransformation.addRootDependency(rootDependency);
    }

    public Transformation<T> getRootTransformation() {
        return this.rootTransformation;
    }

    public void planExecution() {
        if (this.finalized) {
            throw new IllegalStateException("The execution planner should not be finalized multiple times! Finalization is performed before the first execution or explicitly by calling planExecution.");
        }
        HashSet<Transformation> transformationSet = new HashSet<Transformation>();
        HashSet dependenciesProcessed = new HashSet();
        HashMap endNodeMap = new HashMap();
        HashMap contentNodeMap = new HashMap();
        LinkedList collectQueue = new LinkedList();
        LabeledNode rootNode = new LabeledNode();
        collectQueue.add(new CollectEntry(new Node<T>(this.rootTransformation), rootNode));
        while (!collectQueue.isEmpty()) {
            CollectEntry entry = (CollectEntry)collectQueue.poll();
            Node node = entry.nodeToProcess();
            LifecycleUser content = node.getContent();
            LabeledNode labeledNode = content == null ? Optional.ofNullable((LabeledNode)endNodeMap.get(node)).orElseGet(LabeledNode::new) : Optional.ofNullable((LabeledNode)contentNodeMap.get(content)).orElseGet(() -> {
                LabeledNode newNode = new LabeledNode(content);
                contentNodeMap.put(content, newNode);
                return newNode;
            });
            entry.dependent().addDependency(labeledNode);
            if (dependenciesProcessed.contains(node)) continue;
            dependenciesProcessed.add(node);
            if (Transformation.class.isInstance(content)) {
                Transformation transformation = (Transformation)content;
                Node node2 = transformation.getEndDepNode();
                LabeledNode endLabeledNode = Optional.ofNullable((LabeledNode)endNodeMap.get(node2)).orElseGet(() -> {
                    LabeledNode newNode = new LabeledNode();
                    endNodeMap.put(endNode, newNode);
                    return newNode;
                });
                for (Node dependency : node.getDependencies()) {
                    collectQueue.add(new CollectEntry(dependency, endLabeledNode));
                }
                collectQueue.add(new CollectEntry(transformation.getRootDepNode(), labeledNode));
                transformationSet.add(transformation);
                continue;
            }
            for (Node node3 : node.getDependencies()) {
                collectQueue.add(new CollectEntry(node3, labeledNode));
            }
        }
        this.transformations.addAll(transformationSet);
        int maximumDepth = 0;
        LinkedList dfsStack = new LinkedList();
        dfsStack.push(new DFSEntry(rootNode, true));
        while (!dfsStack.isEmpty()) {
            if (dfsStack.size() > dependenciesProcessed.size() * 2) {
                throw new Error("The dependency graph could not be satisfied! There is may be a cycle in it or the root and end nodes are messed up. Check for cycles in the graph after construction and after resolving transformations.");
            }
            DFSEntry entry = (DFSEntry)dfsStack.pop();
            LabeledNode node = entry.node();
            if (entry.enter()) {
                if (node.dfsFinished) continue;
                dfsStack.push(new DFSEntry(node, false));
                for (LabeledNode labeledNode : node.dependencies) {
                    dfsStack.push(new DFSEntry(labeledNode, true));
                }
                continue;
            }
            node.dfsFinished = true;
            for (LabeledNode labeledNode : node.dependencies) {
                if (labeledNode.endDistance <= node.endDistance) continue;
                node.endDistance = labeledNode.endDistance;
            }
            if (!TransformationPhase.class.isInstance(node.content)) continue;
            ++node.endDistance;
            maximumDepth = Math.max(node.endDistance, maximumDepth);
        }
        this.executionLevels = new ArrayList<Collection<TransformationPhase<T>>>(maximumDepth + 1);
        for (int i = 0; i <= maximumDepth; ++i) {
            this.executionLevels.add(new ArrayList());
        }
        for (LabeledNode node : contentNodeMap.values()) {
            if (!TransformationPhase.class.isInstance(node.content)) continue;
            this.executionLevels.get(node.endDistance).add((TransformationPhase)node.content);
        }
        this.finalized = true;
    }

    void removeCurrentPhaseFromWalk() {
        this.proxyListener.removeCurrentListener();
    }

    private void execute(GLSLParser.TranslationUnitContext ctx) {
        if (!this.finalized) {
            this.planExecution();
        }
        this.rootNode = ctx;
        for (Transformation<T> transformation : this.transformations) {
            transformation.setPlanner(this);
            if (!this.initialized) {
                transformation.init();
            }
            transformation.resetState();
        }
        for (Collection collection : this.executionLevels) {
            this.proxyListener = new ProxyParseTreeListener(new ArrayList<PartialParseTreeListener>());
            for (TransformationPhase phase : collection) {
                phase.setPlanner(this);
                if (!this.initialized) {
                    phase.init();
                }
                phase.resetState();
            }
            for (TransformationPhase phase : collection) {
                if (!phase.checkBeforeWalk(ctx)) continue;
                this.proxyListener.add(phase);
                phase.resetWalkFinishState();
            }
            if (!this.proxyListener.isEmpty()) {
                DynamicParseTreeWalker.DEFAULT.walk(this.proxyListener, ctx);
            }
            for (TransformationPhase phase : collection) {
                phase.runAfterWalk(ctx);
            }
        }
        this.rootNode = null;
        this.proxyListener = null;
        this.initialized = true;
    }

    protected void transformTree(GLSLParser.TranslationUnitContext ctx, BufferedTokenStream tokenStream) {
        ctx.makeLocalRoot(tokenStream);
        this.execute(ctx);
    }

    private static class LabeledNode<R> {
        final LifecycleUser<R> content;
        Collection<LabeledNode<R>> dependencies = new HashSet<LabeledNode<R>>();
        int endDistance = -1;
        boolean dfsFinished = false;

        LabeledNode(LifecycleUser<R> content) {
            this.content = content;
        }

        LabeledNode() {
            this.content = null;
        }

        void addDependency(LabeledNode<R> dependency) {
            this.dependencies.add(dependency);
        }
    }

    private static final class CollectEntry<R> {
        private final Node<R> nodeToProcess;
        private final LabeledNode<R> dependent;

        private CollectEntry(Node<R> nodeToProcess, LabeledNode<R> dependent) {
            this.nodeToProcess = nodeToProcess;
            this.dependent = dependent;
        }

        public String toString() {
            return "CollectEntry[" + "nodeToProcess=" + this.nodeToProcess + "," + "dependent=" + this.dependent + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.nodeToProcess != null ? this.nodeToProcess.hashCode() : 0);
            result = 31 * result + (this.dependent != null ? this.dependent.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((CollectEntry)arg0).nodeToProcess, this.nodeToProcess)) {
                return false;
            }
            return Objects.equals(((CollectEntry)arg0).dependent, this.dependent);
            {
            }
        }

        public Node<R> nodeToProcess() {
            return this.nodeToProcess;
        }

        public LabeledNode<R> dependent() {
            return this.dependent;
        }
    }

    private static final class DFSEntry<R> {
        private final LabeledNode<R> node;
        private final boolean enter;

        private DFSEntry(LabeledNode<R> node, boolean enter) {
            this.node = node;
            this.enter = enter;
        }

        public String toString() {
            return "DFSEntry[" + "node=" + this.node + "," + "enter=" + this.enter + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.node != null ? this.node.hashCode() : 0);
            result = 31 * result + (this.enter ? 1 : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((DFSEntry)arg0).node, this.node)) {
                return false;
            }
            return ((DFSEntry)arg0).enter == this.enter;
            {
            }
        }

        public LabeledNode<R> node() {
            return this.node;
        }

        public boolean enter() {
            return this.enter;
        }
    }
}

