/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.transform;

import io.github.douira.glsl_transformer.transform.LifecycleUser;
import java.util.Collection;
import java.util.HashSet;

class Node<T> {
    private LifecycleUser<T> content;
    private Collection<Node<T>> dependencies = new HashSet<Node<T>>();
    private Collection<Node<T>> dependents = new HashSet<Node<T>>();

    Node() {
    }

    Node(LifecycleUser<T> content) {
        this();
        this.content = content;
    }

    LifecycleUser<T> getContent() {
        return this.content;
    }

    void setContent(LifecycleUser<T> content) {
        this.content = content;
    }

    Collection<Node<T>> getDependencies() {
        return this.dependencies;
    }

    Collection<Node<T>> getDependents() {
        return this.dependents;
    }

    void addDependent(Node<T> dependent) {
        if (this.dependents.add(dependent)) {
            dependent.addDependency(this);
        }
    }

    void removeDependent(Node<T> dependent) {
        if (this.dependents.remove(dependent)) {
            dependent.removeDependency(this);
        }
    }

    void addDependency(Node<T> dependency) {
        if (this.dependencies.add(dependency)) {
            dependency.addDependent(this);
        }
    }

    void removeDependency(Node<T> dependency) {
        if (this.dependencies.remove(dependency)) {
            dependency.removeDependent(this);
        }
    }

    private void setDependent(Node<T> dependent, boolean enable) {
        if (this.dependents.contains(dependent) == enable) {
            return;
        }
        if (enable) {
            this.addDependent(dependent);
        } else {
            this.removeDependent(dependent);
        }
    }

    private void setDependency(Node<T> dependency, boolean enable) {
        if (this.dependencies.contains(dependency) == enable) {
            return;
        }
        if (enable) {
            this.addDependency(dependency);
        } else {
            this.removeDependency(dependency);
        }
    }

    void updateRootLink(Node<T> rootNode) {
        if (this != rootNode) {
            boolean setRootLink = this.dependents.isEmpty();
            if (!setRootLink && this.dependents.size() == 1 && this.dependents.contains(rootNode)) {
                return;
            }
            this.setDependent(rootNode, setRootLink);
        }
    }

    void updateEndLink(Node<T> endNode) {
        if (this != endNode) {
            boolean setEndLink = this.dependencies.isEmpty();
            if (!setEndLink && this.dependencies.size() == 1 && this.dependencies.contains(endNode)) {
                return;
            }
            this.setDependency(endNode, setEndLink);
        }
    }

    void updateBothLinks(Node<T> rootNode, Node<T> endNode) {
        this.updateRootLink(rootNode);
        this.updateEndLink(endNode);
    }
}

