/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.core;

import io.github.douira.glsl_transformer.core.target.HandlerTarget;
import io.github.douira.glsl_transformer.transform.WalkPhase;
import io.github.douira.glsl_transformer.tree.TreeMember;
import java.util.Collection;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.TerminalNode;

public abstract class SearchTerminals<T>
extends WalkPhase<T> {
    public static final int IDENTIFIER = 257;
    public static final int ANY_TYPE = 0;
    private boolean exactMatch = true;

    protected abstract Collection<HandlerTarget<T>> getTargets();

    protected int getTerminalTokenType() {
        return 257;
    }

    @Override
    public void visitTerminal(TerminalNode node) {
        Token token = node.getSymbol();
        if (token == null) {
            return;
        }
        int targetType = this.getTerminalTokenType();
        if (targetType == 0 || targetType == token.getType()) {
            String text = token.getText();
            Collection<HandlerTarget<T>> targets = this.getTargets();
            if (targets == null) {
                return;
            }
            for (HandlerTarget target : this.getTargets()) {
                if (!this.findNeedle(text, target)) continue;
                if (!(node instanceof TreeMember)) {
                    throw new IllegalStateException("All nodes in the parse tree should be a TreeMember except for when they are errors! Then the tree is broken anyways.");
                }
                target.setPlanner(this.getPlanner());
                target.handleResult((TreeMember)node, text);
            }
        }
    }

    public void allowInexactMatches() {
        this.exactMatch = false;
    }

    protected boolean findNeedle(String content, HandlerTarget<T> target) {
        return this.exactMatch ? content.equals(target.getNeedle()) : content.contains(target.getNeedle());
    }
}

