/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.core;

import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.core.SearchTerminals;
import io.github.douira.glsl_transformer.core.target.HandlerTarget;
import io.github.douira.glsl_transformer.core.target.ParsedReplaceTargetImpl;
import io.github.douira.glsl_transformer.core.target.TerminalReplaceTargetImpl;
import io.github.douira.glsl_transformer.tree.ExtendedContext;
import io.github.douira.glsl_transformer.util.CompatUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;

public class SearchTerminalsImpl<T>
extends SearchTerminals<T> {
    private int terminalTokenType;
    protected Collection<HandlerTarget<T>> targets;

    public SearchTerminalsImpl(int terminalTokenType, Collection<HandlerTarget<T>> targets) {
        this.terminalTokenType = terminalTokenType;
        this.targets = targets;
    }

    public SearchTerminalsImpl(int terminalTokenType, HandlerTarget<T> target) {
        this(terminalTokenType, CompatUtil.listOf(target));
    }

    public SearchTerminalsImpl(int terminalTokenType) {
        this();
        this.terminalTokenType = terminalTokenType;
    }

    public SearchTerminalsImpl(Collection<HandlerTarget<T>> targets) {
        this(257, targets);
    }

    public SearchTerminalsImpl(HandlerTarget<T> target) {
        this(CompatUtil.listOf(target));
    }

    public SearchTerminalsImpl() {
        this(new HashSet<HandlerTarget<T>>());
    }

    @Override
    public Collection<HandlerTarget<T>> getTargets() {
        return this.targets;
    }

    @Override
    protected int getTerminalTokenType() {
        return this.terminalTokenType;
    }

    public void setTerminalTokenType(int terminalTokenType) {
        this.terminalTokenType = terminalTokenType;
    }

    public void addTarget(HandlerTarget<T> target) {
        this.targets.add(target);
    }

    public void addReplacement(String needle, String newContent, Function<GLSLParser, ExtendedContext> parseMethod) {
        this.addTarget(new ParsedReplaceTargetImpl(needle, newContent, parseMethod));
    }

    public void addReplacementExpression(String needle, String expressionContent) {
        this.addReplacement(needle, expressionContent, GLSLParser::expression);
    }

    public void addReplacementTerminal(String needle, String terminalContent) {
        this.addTarget(new TerminalReplaceTargetImpl(needle, terminalContent));
    }

    public static <T> SearchTerminals<T> withReplacement(final String needle, final String newContent, final Function<GLSLParser, ExtendedContext> parseMethod) {
        return new SearchTerminalsImpl<T>(){
            {
                this.addReplacement(needle, newContent, parseMethod);
            }
        };
    }

    public static <T> SearchTerminals<T> withReplacementExpression(final String needle, final String expressionContent) {
        return new SearchTerminalsImpl<T>(){
            {
                this.addReplacementExpression(needle, expressionContent);
            }
        };
    }

    public static <T> SearchTerminals<T> withReplacementTerminal(final String needle, final String terminalContent) {
        return new SearchTerminalsImpl<T>(){
            {
                this.addReplacementTerminal(needle, terminalContent);
            }
        };
    }
}

