/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.transform;

import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.GLSLParserBaseListener;
import io.github.douira.glsl_transformer.ast.Directive;
import io.github.douira.glsl_transformer.print.EmptyTerminalNode;
import io.github.douira.glsl_transformer.transform.CollectorChild;
import io.github.douira.glsl_transformer.transform.PhaseCollector;
import io.github.douira.glsl_transformer.transform.TransformationManager;
import io.github.douira.glsl_transformer.tree.ExtendedContext;
import io.github.douira.glsl_transformer.tree.TreeMember;
import io.github.douira.glsl_transformer.util.CompatUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.pattern.ParseTreeMatch;
import org.antlr.v4.runtime.tree.pattern.ParseTreePattern;
import org.antlr.v4.runtime.tree.xpath.XPath;

public abstract class TransformationPhase<T>
extends GLSLParserBaseListener
implements CollectorChild<T> {
    private PhaseCollector<T> collector;
    private boolean initialized = false;

    protected boolean checkBeforeWalk(GLSLParser.TranslationUnitContext ctx) {
        return false;
    }

    protected void runAfterWalk(GLSLParser.TranslationUnitContext ctx) {
    }

    protected void lazyInit() {
        if (!this.initialized) {
            this.init();
            this.initialized = true;
        }
    }

    @Override
    public PhaseCollector<T> getCollector() {
        return this.collector;
    }

    @Override
    public void setCollector(PhaseCollector<T> parent) {
        this.collector = parent;
    }

    protected static List<ParseTree> getSiblings(TreeMember node) {
        ExtendedContext parent = node.getParent();
        return parent == null ? null : parent.children;
    }

    protected void replaceNode(TreeMember removeNode, String newContent, Function<GLSLParser, ExtendedContext> parseMethod) {
        this.replaceNode(removeNode, this.createLocalRoot(newContent, removeNode.getParent(), parseMethod));
    }

    protected int replaceNode(TreeMember removeNode, TreeMember newNode) {
        ExtendedContext parent = removeNode.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("The root node may not be removed!");
        }
        newNode.setPreviousNode(removeNode);
        List children = parent.children;
        int index = children.indexOf(removeNode);
        newNode.setParent((RuleContext)parent);
        children.set(index, newNode);
        removeNode.omitTokens();
        return index;
    }

    protected int removeNode(TreeMember removeNode) {
        return this.replaceNode(removeNode, new EmptyTerminalNode());
    }

    protected XPath compilePath(String xpath) {
        return new XPath(this.getParser(), xpath);
    }

    protected ParseTreePattern compilePattern(String pattern, int rootRule) {
        return this.getParser().compileParseTreePattern(pattern, rootRule, this.getLexer());
    }

    protected List<ParseTreeMatch> findAndMatch(ParseTree tree, XPath xpath, ParseTreePattern pattern) {
        Collection subtrees = xpath.evaluate(tree);
        ArrayList<ParseTreeMatch> matches = new ArrayList<ParseTreeMatch>();
        for (ParseTree sub : subtrees) {
            ParseTreeMatch match = pattern.match(sub);
            if (!match.succeeded()) continue;
            matches.add(match);
        }
        return matches;
    }

    protected boolean isActive() {
        return true;
    }

    protected void init() {
    }

    protected <RuleType extends ExtendedContext> RuleType createLocalRoot(String str, ExtendedContext parent, Function<GLSLParser, RuleType> parseMethod) {
        RuleType node = TransformationManager.INTERNAL.parse(str, parent, parseMethod);
        ((ExtendedContext)node).makeLocalRoot(TransformationManager.INTERNAL.tokenStream);
        return node;
    }

    private int getInjectionIndex(InjectionPoint location) {
        GLSLParser.TranslationUnitContext rootNode = this.getRootNode();
        int injectIndex = -1;
        if (location == InjectionPoint.BEFORE_VERSION) {
            injectIndex = rootNode.getChildIndexLike(GLSLParser.VersionStatementContext.class);
            if (injectIndex == rootNode.getChildCount()) {
                injectIndex = 0;
            }
        } else if (location == InjectionPoint.BEFORE_EOF) {
            injectIndex = rootNode.getChildCount();
        } else {
            GLSLParser.ExternalDeclarationContext externalDeclaration;
            ParseTree child;
            ParseTree parseTree;
            Set<Class<? extends ParseTree>> beforeTypes = location.EDBeforeTypes;
            if (beforeTypes == null) {
                throw new Error("A non-special injection point is missing its EDBeforeTypes!");
            }
            while (!((parseTree = rootNode.getChild(++injectIndex)) instanceof GLSLParser.ExternalDeclarationContext && (child = (externalDeclaration = (GLSLParser.ExternalDeclarationContext)parseTree).getChild(0)) instanceof ExtendedContext && beforeTypes.contains(child.getClass()) || injectIndex >= rootNode.getChildCount())) {
            }
        }
        return injectIndex;
    }

    protected void injectNode(InjectionPoint location, ParseTree newNode) {
        this.getRootNode().addChild(this.getInjectionIndex(location), newNode);
    }

    protected void injectDefine(InjectionPoint location, String content) {
        this.injectNode(location, new Directive(Directive.Type.DEFINE, content));
    }

    protected void injectExternalDeclaration(InjectionPoint location, String str) {
        this.injectNode(location, this.createLocalRoot(str, this.getRootNode(), GLSLParser::externalDeclaration));
    }

    protected void injectExternalDeclarations(InjectionPoint location, String ... str) {
        ParseTree[] nodes = new ParseTree[str.length];
        GLSLParser.TranslationUnitContext rootNode = this.getRootNode();
        for (int i = 0; i < str.length; ++i) {
            nodes[i] = this.createLocalRoot(str[i], rootNode, GLSLParser::externalDeclaration);
        }
        this.injectNodes(location, nodes);
    }

    protected void injectNodes(InjectionPoint location, Deque<ParseTree> newNodes) {
        int injectIndex = this.getInjectionIndex(location);
        GLSLParser.TranslationUnitContext rootNode = this.getRootNode();
        newNodes.descendingIterator().forEachRemaining(newNode -> rootNode.addChild(injectIndex, (ParseTree)newNode));
    }

    protected void injectNodes(InjectionPoint location, ParseTree ... newNodes) {
        int injectIndex = this.getInjectionIndex(location);
        GLSLParser.TranslationUnitContext rootNode = this.getRootNode();
        for (int i = newNodes.length - 1; i >= 0; --i) {
            rootNode.addChild(injectIndex, newNodes[i]);
        }
    }

    public static enum InjectionPoint {
        BEFORE_VERSION,
        BEFORE_EXTENSIONS,
        BEFORE_DIRECTIVES,
        BEFORE_DECLARATIONS,
        BEFORE_FUNCTIONS,
        BEFORE_EOF;

        public Set<Class<? extends ParseTree>> EDBeforeTypes;

        static {
            InjectionPoint.BEFORE_FUNCTIONS.EDBeforeTypes = CompatUtil.setOf(GLSLParser.FunctionDefinitionContext.class);
            InjectionPoint.BEFORE_DECLARATIONS.EDBeforeTypes = new HashSet<Class<? extends ParseTree>>(InjectionPoint.BEFORE_FUNCTIONS.EDBeforeTypes);
            InjectionPoint.BEFORE_DECLARATIONS.EDBeforeTypes.add(GLSLParser.LayoutDefaultsContext.class);
            InjectionPoint.BEFORE_DECLARATIONS.EDBeforeTypes.add(GLSLParser.DeclarationContext.class);
            InjectionPoint.BEFORE_DIRECTIVES.EDBeforeTypes = new HashSet<Class<? extends ParseTree>>(InjectionPoint.BEFORE_DECLARATIONS.EDBeforeTypes);
            InjectionPoint.BEFORE_DIRECTIVES.EDBeforeTypes.add(GLSLParser.PragmaStatementContext.class);
            InjectionPoint.BEFORE_EXTENSIONS.EDBeforeTypes = new HashSet<Class<? extends ParseTree>>(InjectionPoint.BEFORE_DIRECTIVES.EDBeforeTypes);
            InjectionPoint.BEFORE_EXTENSIONS.EDBeforeTypes.add(GLSLParser.ExtensionStatementContext.class);
        }
    }
}

