/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.transform;

import io.github.douira.glsl_transformer.transform.CollectorChildImpl;
import io.github.douira.glsl_transformer.transform.PhaseCollector;
import io.github.douira.glsl_transformer.transform.TransformationPhase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class Transformation<T>
extends CollectorChildImpl<T> {
    public static final int DEFAULT_GROUP = 0;
    private final List<PhaseEntry<T>> phaseRegistry = new ArrayList<PhaseEntry<T>>();
    private int nextPhaseIndex = 1;
    private final List<Transformation<T>> childTransformations = new LinkedList<Transformation<T>>();

    public Transformation(TransformationPhase<T> phase) {
        this.addPhase(phase);
    }

    public Transformation() {
    }

    public void addPhase(TransformationPhase<T> phase) {
        this.addPhase(this.nextPhaseIndex++, phase);
    }

    public void addPhase(int index, TransformationPhase<T> phase) {
        this.addPhase(index, this.getDefaultGroup(), phase);
    }

    public void addPhase(int index, int group, TransformationPhase<T> phase) {
        this.addPhase(new PhaseEntry<T>(phase, index, group));
    }

    public void addPhase(PhaseEntry<T> entry) {
        if (entry.phase() != null) {
            this.phaseRegistry.add(entry);
        }
    }

    public void addConcurrentPhase(TransformationPhase<T> phase) {
        this.addPhase(Math.max(1, this.nextPhaseIndex - 1), phase);
    }

    public void addPhases(Collection<PhaseEntry<T>> entries) {
        this.phaseRegistry.addAll(entries);
    }

    protected int getDefaultGroup() {
        return 0;
    }

    protected void resetState() {
    }

    void resetStateInternal() {
        this.resetState();
        for (Transformation<T> child : this.childTransformations) {
            child.resetState();
        }
    }

    @Override
    public void setCollector(PhaseCollector<T> collector) {
        super.setCollector(collector);
        for (Transformation<T> child : this.childTransformations) {
            child.setCollector(collector);
        }
    }

    void addPhasesTo(PhaseCollector<T> collector) {
        for (PhaseEntry<T> entry : this.phaseRegistry) {
            collector.addPhaseAt(entry);
        }
    }

    public void merge(Transformation<T> other) {
        this.addPhases(other.phaseRegistry);
        this.childTransformations.add(other);
    }

    public void append(Transformation<T> other) {
        int maxIndex = Integer.MIN_VALUE;
        for (PhaseEntry<T> entry : other.phaseRegistry) {
            int index = ((PhaseEntry)entry).index;
            this.addPhase(index += this.nextPhaseIndex - 1, entry.group(), entry.phase());
            maxIndex = Math.max(maxIndex, index);
        }
        this.nextPhaseIndex = maxIndex + 1;
        this.childTransformations.add(other);
    }

    public static final class PhaseEntry<T> {
        private final TransformationPhase<T> phase;
        private final int index;
        private final int group;

        public PhaseEntry(TransformationPhase<T> phase, int index, int group) {
            this.phase = phase;
            this.index = index;
            this.group = group;
        }

        public String toString() {
            return "PhaseEntry[" + "phase=" + this.phase + "," + "index=" + this.index + "," + "group=" + this.group + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.phase != null ? this.phase.hashCode() : 0);
            result = 31 * result + this.index;
            result = 31 * result + this.group;
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((PhaseEntry)arg0).phase, this.phase)) {
                return false;
            }
            if (((PhaseEntry)arg0).index != this.index) {
                return false;
            }
            return ((PhaseEntry)arg0).group == this.group;
            {
            }
        }

        public TransformationPhase<T> phase() {
            return this.phase;
        }

        public int index() {
            return this.index;
        }

        public int group() {
            return this.group;
        }
    }
}

