/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.print;

import io.github.douira.glsl_transformer.ast.UnparsableASTNode;
import io.github.douira.glsl_transformer.print.CachingIntervalSet;
import io.github.douira.glsl_transformer.print.filter.TokenFilter;
import io.github.douira.glsl_transformer.tree.ExtendedContext;
import java.util.LinkedList;
import java.util.Objects;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.AbstractParseTreeVisitor;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;

public class PrintVisitor
extends AbstractParseTreeVisitor<Void> {
    private final LinkedList<Object> printItems = new LinkedList();
    private Interval cachedInterval;
    private ExtendedContext currentRoot;

    private PrintVisitor() {
    }

    private static boolean inInterval(Interval interval, int el) {
        return interval.a <= el && interval.b >= el;
    }

    public static String printTree(BufferedTokenStream rootTokenStream, ExtendedContext tree, TokenFilter<?> tokenFilter) {
        tree.makeLocalRoot(rootTokenStream);
        return new PrintVisitor().visitAndJoin(rootTokenStream, tree, tree.getFullSourceInterval(), tokenFilter);
    }

    public static String printTree(BufferedTokenStream rootTokenStream, ExtendedContext tree) {
        return PrintVisitor.printTree(rootTokenStream, tree, null);
    }

    private String visitAndJoin(BufferedTokenStream rootTokenStream, ExtendedContext rootNode, Interval bounds, TokenFilter<?> tokenFilter) {
        this.currentRoot = rootNode;
        this.visit(rootNode);
        if (tokenFilter != null) {
            tokenFilter.resetState();
        }
        StringBuilder builder = new StringBuilder(512);
        for (Object e : this.printItems) {
            Object e2 = e;
            if (e2 instanceof String) {
                String literal = (String)e2;
                builder.append(literal);
                continue;
            }
            e2 = e;
            if (e2 instanceof AttributedInterval) {
                AttributedInterval attributedInterval = (AttributedInterval)e2;
                Interval interval = attributedInterval.interval();
                ExtendedContext localRoot = attributedInterval.localRoot();
                CachingIntervalSet omissionSet = localRoot.getOmissionSet();
                for (Token token : localRoot.getTokenStream().getTokens(interval.a, interval.b)) {
                    int tokenIndex = token.getTokenIndex();
                    if (token.getType() == -1 || tokenIndex != -1 && (localRoot == rootNode && !PrintVisitor.inInterval(bounds, tokenIndex) || !omissionSet.tokenNotOmitted(token) || tokenFilter != null && !tokenFilter.isTokenAllowed(token))) continue;
                    builder.append(token.getText());
                }
                continue;
            }
            throw new Error("A wrong type of object was inserted into the printItems! Only String and AttributedInterval are allowed.");
        }
        return builder.toString();
    }

    private void addInterval(int a, int b) {
        Interval interval;
        if (a > b || a < 0 || b < 0) {
            return;
        }
        if (this.cachedInterval != null && a == this.cachedInterval.a && b == this.cachedInterval.b) {
            interval = this.cachedInterval;
        } else {
            this.cachedInterval = interval = Interval.of((int)a, (int)b);
        }
        this.addInterval(interval);
    }

    private void addInterval(Interval newInterval) {
        AttributedInterval lastPrintInterval;
        Interval lastInterval;
        Object lastPrintItem;
        Object object;
        if (newInterval.length() == 0) {
            return;
        }
        if (!this.printItems.isEmpty() && (object = (lastPrintItem = this.printItems.getLast())) instanceof AttributedInterval && (lastInterval = (lastPrintInterval = (AttributedInterval)object).interval()) != null && this.currentRoot == lastPrintInterval.localRoot() && (!lastInterval.disjoint(newInterval) || lastInterval.adjacent(newInterval))) {
            if (lastInterval.properlyContains(newInterval)) {
                return;
            }
            this.printItems.removeLast();
            newInterval = lastInterval.union(newInterval);
        }
        this.printItems.add(new AttributedInterval(this.currentRoot, newInterval));
    }

    private void addLiteral(String literal) {
        if (literal == null || literal.isEmpty()) {
            return;
        }
        this.printItems.add(literal);
    }

    public Void visitChildren(RuleNode node) {
        ExtendedContext context = (ExtendedContext)node.getRuleContext();
        Interval superInterval = context.getLargestSourceInterval();
        boolean lastWasUnparsableASTNode = false;
        int fetchNext = superInterval.a;
        if (context.children != null) {
            for (ParseTree child : context.children) {
                ExtendedContext childNode;
                if (child instanceof UnparsableASTNode) {
                    if (!lastWasUnparsableASTNode) {
                        this.addLiteral("\n");
                        lastWasUnparsableASTNode = true;
                    }
                    child.accept((ParseTreeVisitor)this);
                    continue;
                }
                lastWasUnparsableASTNode = false;
                ParseTree parseTree = child;
                if (parseTree instanceof ExtendedContext && (childNode = (ExtendedContext)parseTree).isLocalRoot()) {
                    ExtendedContext previousRoot = this.currentRoot;
                    this.currentRoot = childNode;
                    child.accept((ParseTreeVisitor)this);
                    this.currentRoot = previousRoot;
                    continue;
                }
                Interval childInterval = child.getSourceInterval();
                this.addInterval(fetchNext, childInterval.a - 1);
                child.accept((ParseTreeVisitor)this);
                if (childInterval.length() == 0) continue;
                fetchNext = childInterval.b + 1;
            }
        }
        this.addInterval(fetchNext, superInterval.b);
        return null;
    }

    public Void visitTerminal(TerminalNode node) {
        this.addInterval(node.getSourceInterval());
        TerminalNode terminalNode = node;
        if (terminalNode instanceof UnparsableASTNode) {
            UnparsableASTNode astNode = (UnparsableASTNode)terminalNode;
            this.addLiteral(astNode.getText());
        }
        return null;
    }

    private static final class AttributedInterval {
        private final ExtendedContext localRoot;
        private final Interval interval;

        private AttributedInterval(ExtendedContext localRoot, Interval interval) {
            this.localRoot = localRoot;
            this.interval = interval;
        }

        public String toString() {
            return "AttributedInterval[" + "localRoot=" + this.localRoot + "," + "interval=" + this.interval + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.localRoot != null ? this.localRoot.hashCode() : 0);
            result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((AttributedInterval)arg0).localRoot, this.localRoot)) {
                return false;
            }
            return Objects.equals(((AttributedInterval)arg0).interval, this.interval);
            {
            }
        }

        public ExtendedContext localRoot() {
            return this.localRoot;
        }

        public Interval interval() {
            return this.interval;
        }
    }
}

