/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.core;

import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.core.target.HandlerTarget;
import io.github.douira.glsl_transformer.core.target.ParsedReplaceTargetImpl;
import io.github.douira.glsl_transformer.core.target.TerminalReplaceTargetImpl;
import io.github.douira.glsl_transformer.transform.WalkPhase;
import io.github.douira.glsl_transformer.tree.ExtendedContext;
import io.github.douira.glsl_transformer.tree.TreeMember;
import io.github.douira.glsl_transformer.util.CompatUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.TerminalNode;

public class SearchTerminals<T>
extends WalkPhase<T> {
    public static final int IDENTIFIER = 257;
    protected final Collection<HandlerTarget<T>> targets;
    private int terminalTokenType;
    private boolean exactMatch = true;

    public SearchTerminals(int terminalTokenType, Collection<HandlerTarget<T>> targets) {
        this.terminalTokenType = terminalTokenType;
        this.targets = targets;
    }

    public SearchTerminals(int terminalTokenType, HandlerTarget<T> target) {
        this(terminalTokenType, CompatUtil.listOf(target));
    }

    public SearchTerminals(Collection<HandlerTarget<T>> targets) {
        this(257, targets);
    }

    public SearchTerminals(HandlerTarget<T> target) {
        this(CompatUtil.listOf(target));
    }

    public SearchTerminals() {
        this(new HashSet<HandlerTarget<T>>());
    }

    @Override
    public void visitTerminal(TerminalNode node) {
        Token token = node.getSymbol();
        if (token.getType() == this.terminalTokenType) {
            String text = token.getText();
            for (HandlerTarget target : this.targets) {
                if (!this.findNeedle(text, target)) continue;
                if (!(node instanceof TreeMember)) {
                    throw new IllegalStateException("All nodes in the parse tree should be a TreeMember except for when they are errors! Then the tree is broken anyways.");
                }
                target.setCollector(this.getCollector());
                target.handleResult((TreeMember)node, text);
            }
        }
    }

    public void allowInexactMatches() {
        this.exactMatch = false;
    }

    public void setTerminalTokenType(int terminalTokenType) {
        this.terminalTokenType = terminalTokenType;
    }

    public void addTarget(HandlerTarget<T> target) {
        this.targets.add(target);
    }

    protected boolean findNeedle(String content, HandlerTarget<T> target) {
        return this.exactMatch ? content.equals(target.getNeedle()) : content.contains(target.getNeedle());
    }

    public void addReplacement(String needle, String newContent, Function<GLSLParser, ExtendedContext> parseMethod) {
        this.addTarget(new ParsedReplaceTargetImpl(needle, newContent, parseMethod));
    }

    public void addReplacementExpression(String needle, String expressionContent) {
        this.addReplacement(needle, expressionContent, GLSLParser::expression);
    }

    public void addReplacementTerminal(String needle, String terminalContent) {
        this.addTarget(new TerminalReplaceTargetImpl(needle, terminalContent));
    }

    public static <T> SearchTerminals<T> withReplacement(final String needle, final String newContent, final Function<GLSLParser, ExtendedContext> parseMethod) {
        return new SearchTerminals<T>(){
            {
                this.addReplacement(needle, newContent, parseMethod);
            }
        };
    }

    public static <T> SearchTerminals<T> withReplacementExpression(final String needle, final String expressionContent) {
        return new SearchTerminals<T>(){
            {
                this.addReplacementExpression(needle, expressionContent);
            }
        };
    }

    public static <T> SearchTerminals<T> withReplacementTerminal(final String needle, final String terminalContent) {
        return new SearchTerminals<T>(){
            {
                this.addReplacementTerminal(needle, terminalContent);
            }
        };
    }
}

