/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.print.filter;

import io.github.douira.glsl_transformer.print.filter.TokenFilter;
import io.github.douira.glsl_transformer.transform.PhaseCollector;
import java.util.ArrayList;
import java.util.Collection;
import org.antlr.v4.runtime.Token;

public class MultiFilter<T>
extends TokenFilter<T> {
    private Collection<TokenFilter<T>> subfilters;
    private boolean conjunction = true;
    private boolean shortCircuit = false;

    public MultiFilter(Collection<TokenFilter<T>> subfilters, boolean conjunction, boolean shortCircuit) {
        this(subfilters);
        this.conjunction = conjunction;
        this.shortCircuit = shortCircuit;
    }

    public MultiFilter(int initialCapacity, boolean conjunction, boolean shortCircuit) {
        this(new ArrayList<TokenFilter<T>>(initialCapacity), conjunction, shortCircuit);
    }

    public MultiFilter(boolean conjunction, boolean shortCircuit) {
        this.conjunction = conjunction;
        this.shortCircuit = shortCircuit;
    }

    public MultiFilter(Collection<? extends TokenFilter<T>> subfilters) {
        this.subfilters = new ArrayList<TokenFilter<T>>();
    }

    public MultiFilter(int initialCapacity) {
        this.subfilters = new ArrayList<TokenFilter<T>>(initialCapacity);
    }

    public MultiFilter() {
    }

    public void setConjunction(boolean conjunction) {
        this.conjunction = conjunction;
    }

    public void setShortCircuit(boolean shortCircuit) {
        this.shortCircuit = shortCircuit;
    }

    public boolean add(TokenFilter<T> filter) {
        return this.subfilters.add(filter);
    }

    public boolean addAll(Collection<? extends TokenFilter<T>> newSubfilters) {
        return this.subfilters.addAll(newSubfilters);
    }

    public boolean addAll(MultiFilter<T> other) {
        return this.addAll(other.subfilters);
    }

    public MultiFilter<T> clone() {
        return new MultiFilter<T>(this.subfilters, this.conjunction, this.shortCircuit);
    }

    @Override
    public void resetState() {
        for (TokenFilter<T> filter : this.subfilters) {
            filter.resetState();
        }
    }

    @Override
    public boolean isTokenAllowed(Token token) {
        boolean result = this.conjunction;
        for (TokenFilter<T> filter : this.subfilters) {
            boolean verdict = filter.isTokenAllowed(token);
            boolean bl = this.conjunction ? result && verdict : (result = result || verdict);
            if (!this.shortCircuit || result == this.conjunction) continue;
            return result;
        }
        return result;
    }

    @Override
    public void setCollector(PhaseCollector<T> collector) {
        super.setCollector(collector);
        for (TokenFilter<T> subfilter : this.subfilters) {
            subfilter.setCollector(collector);
        }
    }
}

