/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.transform;

import io.github.douira.glsl_transformer.GLSLLexer;
import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.transform.DynamicParseTreeWalker;
import io.github.douira.glsl_transformer.transform.ProxyParseTreeListener;
import io.github.douira.glsl_transformer.transform.Transformation;
import io.github.douira.glsl_transformer.transform.TransformationPhase;
import io.github.douira.glsl_transformer.util.ComparablePair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.tree.ParseTreeListener;

public abstract class PhaseCollector<T> {
    private final Map<ComparablePair<Integer, Integer>, List<TransformationPhase<T>>> executionLevels = new TreeMap<ComparablePair<Integer, Integer>, List<TransformationPhase<T>>>();
    private final Collection<Transformation<T>> transformations = new ArrayList<Transformation<T>>();
    private GLSLParser.TranslationUnitContext rootNode;

    public abstract GLSLParser getParser();

    public abstract GLSLLexer getLexer();

    abstract T getJobParameters();

    GLSLParser.TranslationUnitContext getRootNode() {
        return this.rootNode;
    }

    public void registerTransformation(Transformation<T> transformation) {
        transformation.addPhasesTo(this);
        this.transformations.add(transformation);
    }

    public void registerTransformationMultiple(Consumer<PhaseCollector<T>> groupRegisterer) {
        groupRegisterer.accept(this);
    }

    void addPhaseAt(Transformation.PhaseEntry<T> entry) {
        TransformationPhase<T> phase = entry.phase();
        ComparablePair<Integer, Integer> indexPair = new ComparablePair<Integer, Integer>(entry.group(), entry.order());
        List<TransformationPhase<T>> phasesForIndex = this.executionLevels.get(indexPair);
        if (phasesForIndex == null) {
            phasesForIndex = new ArrayList<TransformationPhase<T>>();
            this.executionLevels.put(indexPair, phasesForIndex);
        }
        phasesForIndex.add(phase);
        phase.setCollector(this);
        phase.init();
    }

    private void execute(GLSLParser.TranslationUnitContext ctx) {
        this.rootNode = ctx;
        for (Transformation<T> transformation : this.transformations) {
            transformation.resetState();
        }
        for (List list : this.executionLevels.values()) {
            ProxyParseTreeListener proxyListener = new ProxyParseTreeListener(new ArrayList<ParseTreeListener>());
            for (TransformationPhase phase : list) {
                phase.setCollector(this);
                if (!phase.checkBeforeWalk(ctx)) continue;
                proxyListener.add(phase);
            }
            if (!proxyListener.isEmpty()) {
                DynamicParseTreeWalker.DEFAULT.walk(proxyListener, ctx);
            }
            for (TransformationPhase phase : list) {
                phase.runAfterWalk(ctx);
            }
        }
        this.rootNode = null;
    }

    protected void transformTree(GLSLParser.TranslationUnitContext ctx, BufferedTokenStream tokenStream) {
        ctx.makeLocalRoot(tokenStream);
        this.execute(ctx);
    }
}

