/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.transform;

import io.github.douira.glsl_transformer.transform.PhaseCollector;
import io.github.douira.glsl_transformer.transform.TransformationPhase;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class Transformation<T> {
    public static final int DEFAULT_GROUP = 0;
    private final List<PhaseEntry<T>> phaseRegistry = new LinkedList<PhaseEntry<T>>();
    private int phaseCounter = 1;

    public Transformation(TransformationPhase<T> phase) {
        this.addPhase(phase);
    }

    public Transformation() {
    }

    public void addPhase(TransformationPhase<T> phase) {
        this.addPhase(this.phaseCounter++, phase);
    }

    public void addPhase(int order, TransformationPhase<T> phase) {
        this.addPhase(order, this.getDefaultGroup(), phase);
    }

    public void addPhase(int order, int group, TransformationPhase<T> phase) {
        this.addPhase(new PhaseEntry<T>(phase, order, group));
    }

    public void addPhase(PhaseEntry<T> entry) {
        if (entry.phase() != null) {
            this.phaseRegistry.add(entry);
        }
    }

    public void addConcurrentPhase(TransformationPhase<T> phase) {
        this.addPhase(this.phaseCounter - 1, phase);
    }

    protected int getDefaultGroup() {
        return 0;
    }

    protected void resetState() {
    }

    void addPhasesTo(PhaseCollector<T> collector) {
        for (PhaseEntry<T> entry : this.phaseRegistry) {
            collector.addPhaseAt(entry);
        }
    }

    public static final class PhaseEntry<T> {
        private final TransformationPhase<T> phase;
        private final int order;
        private final int group;

        public PhaseEntry(TransformationPhase<T> phase, int order, int group) {
            this.phase = phase;
            this.order = order;
            this.group = group;
        }

        public String toString() {
            return "PhaseEntry[" + "phase=" + this.phase + "," + "order=" + this.order + "," + "group=" + this.group + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.phase != null ? this.phase.hashCode() : 0);
            result = 31 * result + this.order;
            result = 31 * result + this.group;
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((PhaseEntry)arg0).phase, this.phase)) {
                return false;
            }
            if (((PhaseEntry)arg0).order != this.order) {
                return false;
            }
            return ((PhaseEntry)arg0).group == this.group;
            {
            }
        }

        public TransformationPhase<T> phase() {
            return this.phase;
        }

        public int order() {
            return this.order;
        }

        public int group() {
            return this.group;
        }
    }
}

