/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.print;

import io.github.douira.glsl_transformer.print.filter.TokenFilter;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.IntervalSet;

public class CachingIntervalSet
extends IntervalSet
implements TokenFilter {
    private Interval lastIntervalHit;

    public CachingIntervalSet() {
        super(new int[0]);
    }

    public boolean contains(int el) {
        if (this.readonly && this.lastIntervalHit != null && this.lastIntervalHit.a <= el && this.lastIntervalHit.b >= el) {
            return true;
        }
        int n = this.intervals.size();
        int l = 0;
        int r = n - 1;
        while (l <= r) {
            int m = (l + r) / 2;
            Interval I = (Interval)this.intervals.get(m);
            int a = I.a;
            int b = I.b;
            if (b < el) {
                l = m + 1;
                continue;
            }
            if (a > el) {
                r = m - 1;
                continue;
            }
            if (this.readonly) {
                this.lastIntervalHit = I;
            }
            return true;
        }
        return false;
    }

    public void add(Interval interval) {
        super.add(interval);
    }

    @Override
    public boolean isTokenAllowed(Token token) {
        return token.getChannel() != 0 || !this.contains(token.getTokenIndex());
    }
}

