/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.core;

import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.core.SearchTerminals;
import io.github.douira.glsl_transformer.core.target.HandlerTarget;
import io.github.douira.glsl_transformer.core.target.ParsedReplaceTarget;
import io.github.douira.glsl_transformer.core.target.ThrowTarget;
import io.github.douira.glsl_transformer.transform.RunPhase;
import io.github.douira.glsl_transformer.transform.Transformation;
import io.github.douira.glsl_transformer.transform.TransformationPhase;

public class WrapIdentifier<T>
extends Transformation<T> {
    public WrapIdentifier(String wrapTarget, String wrapResult, HandlerTarget<T> replaceTarget, RunPhase<T> wrappingInjector) {
        this.addPhase(new SearchTerminals(ThrowTarget.fromMessage(wrapResult, "The wrapper '" + wrapResult + "' can't already be in the string!")));
        this.addPhase(new SearchTerminals<T>(replaceTarget));
        this.addConcurrentPhase(wrappingInjector);
    }

    public static <T> WrapIdentifier<T> fromExpression(String wrapTarget, String wrapResult, String wrapExpression, RunPhase<T> wrappingInjector) {
        return new WrapIdentifier(wrapTarget, wrapResult, new ParsedReplaceTarget(wrapTarget, wrapExpression, GLSLParser::expression), wrappingInjector);
    }

    public static <T> WrapIdentifier<T> withExternalDeclaration(String wrapTarget, String wrapResult, String wrapExpression, final TransformationPhase.InjectionPoint location, final String injectedCode) {
        return WrapIdentifier.fromExpression(wrapTarget, wrapResult, wrapExpression, new RunPhase<T>(){

            @Override
            protected void run(GLSLParser.TranslationUnitContext ctx) {
                this.injectExternalDeclaration(location, injectedCode);
            }
        });
    }
}

