/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.core;

import io.github.douira.glsl_transformer.core.target.HandlerTarget;
import io.github.douira.glsl_transformer.transform.WalkPhase;
import io.github.douira.glsl_transformer.tree.TreeMember;
import io.github.douira.glsl_transformer.util.CompatUtil;
import java.util.Collection;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.TerminalNode;

public class SearchTerminals
extends WalkPhase {
    public static final int IDENTIFIER = 257;
    protected Collection<HandlerTarget> targets;
    private int terminalTokenType;

    public SearchTerminals(int terminalTokenType, Collection<HandlerTarget> targets) {
        this.terminalTokenType = terminalTokenType;
        this.targets = targets;
    }

    public SearchTerminals(int terminalTokenType, HandlerTarget target) {
        this(terminalTokenType, CompatUtil.listOf(target));
    }

    public SearchTerminals(HandlerTarget target) {
        this(257, CompatUtil.listOf(target));
    }

    @Override
    public void visitTerminal(TerminalNode node) {
        Token token = node.getSymbol();
        if (token.getType() == this.terminalTokenType) {
            String text = token.getText();
            for (HandlerTarget target : this.targets) {
                if (!text.contains(target.getNeedle())) continue;
                if (!(node instanceof TreeMember)) {
                    throw new IllegalStateException("All nodes in the parse tree should be a TreeMember except for when they are errors! Then the tree is broken anyways.");
                }
                target.setCollector(this.getCollector());
                target.handleResult((TreeMember)node, text);
            }
        }
    }

    public void addTarget(HandlerTarget target) {
        this.targets.add(target);
    }
}

