/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.core;

import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.transform.SemanticException;
import io.github.douira.glsl_transformer.transform.Transformation;
import io.github.douira.glsl_transformer.transform.TransformationPhase;
import io.github.douira.glsl_transformer.transform.WalkPhase;
import io.github.douira.glsl_transformer.tree.ExtendedContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.pattern.ParseTreeMatch;
import org.antlr.v4.runtime.tree.pattern.ParseTreePattern;

public class ReplaceDeclarations
extends Transformation {
    private Map<String, Declaration> declarations;

    @Override
    protected void resetState() {
        this.declarations = new HashMap<String, Declaration>();
    }

    public ReplaceDeclarations() {
        this.addPhase(new WalkPhase(){
            ParseTreePattern declarationPattern;

            @Override
            protected void init() {
                this.declarationPattern = this.compilePattern("layout (location = 0) <type:storageQualifier> vec4 <name:IDENTIFIER>;", 2);
            }

            @Override
            public void enterExternalDeclaration(GLSLParser.ExternalDeclarationContext ctx) {
                ParseTreeMatch match = this.declarationPattern.match((ParseTree)ctx);
                if (match.succeeded()) {
                    String type = match.get("type").getText();
                    String name = match.get("name").getText();
                    if (name == "iris_Position") {
                        throw new SemanticException(String.format("Disallowed GLSL declaration with the name \"{0}\"!", name), ctx);
                    }
                    if (type.equals("in") || type.equals("attribute")) {
                        ReplaceDeclarations.this.declarations.put(name, new Declaration(type, name));
                        this.removeNode((ExtendedContext)match.getTree());
                    }
                }
            }

            @Override
            public void enterFunctionHeader(GLSLParser.FunctionHeaderContext ctx) {
                if (ctx.IDENTIFIER().getText().equals("iris_getModelSpaceVertexPosition")) {
                    throw new SemanticException(String.format("Disallowed GLSL declaration with the name \"{0}\"!", "iris_getModelSpaceVertexPosition"), ctx);
                }
            }

            @Override
            protected boolean isActiveAfterWalk() {
                return !ReplaceDeclarations.this.declarations.isEmpty();
            }

            @Override
            protected void afterWalk(GLSLParser.TranslationUnitContext ctx) {
                this.injectExternalDeclaration("void iris_getModelSpaceVertexPosition() { }", TransformationPhase.InjectionPoint.BEFORE_EOF);
                this.injectExternalDeclaration("layout (location = 0) attribute vec4 iris_Position;", TransformationPhase.InjectionPoint.BEFORE_FUNCTIONS);
            }
        });
        this.addPhase(new WalkPhase(){

            @Override
            protected boolean isActive() {
                return !ReplaceDeclarations.this.declarations.isEmpty();
            }

            @Override
            public void enterVariableIdentifier(GLSLParser.VariableIdentifierContext ctx) {
                TerminalNode identifier = ctx.IDENTIFIER();
                Declaration matchingDeclaration = (Declaration)ReplaceDeclarations.this.declarations.get(identifier.getText());
                if (matchingDeclaration != null) {
                    this.replaceNode(ctx, "iris_getModelSpaceVertexPosition()", GLSLParser::expression);
                }
            }
        });
    }

    private static final class Declaration {
        private final String type;
        private final String name;

        private Declaration(String type, String name) {
            this.type = type;
            this.name = name;
        }

        public String toString() {
            return "Declaration[" + "type=" + this.type + "," + "name=" + this.name + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((Declaration)arg0).type, this.type)) {
                return false;
            }
            return Objects.equals(((Declaration)arg0).name, this.name);
            {
            }
        }

        public String type() {
            return this.type;
        }

        public String name() {
            return this.name;
        }
    }
}

