/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.transform;

import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.generic.ProxyParseTreeListener;
import io.github.douira.glsl_transformer.transform.DynamicParseTreeWalker;
import io.github.douira.glsl_transformer.transform.RunPhase;
import io.github.douira.glsl_transformer.transform.Transformation;
import io.github.douira.glsl_transformer.transform.TransformationPhase;
import io.github.douira.glsl_transformer.transform.WalkPhase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;

public class PhaseCollector {
    private Parser parser;
    private Map<Integer, List<TransformationPhase>> phases = new TreeMap<Integer, List<TransformationPhase>>();
    private Collection<Transformation> transformations = new ArrayList<Transformation>();
    private GLSLParser.TranslationUnitContext rootNode;

    public PhaseCollector(Parser parser) {
        this.parser = parser;
    }

    public void registerTransformation(Transformation transformation) {
        transformation.setCollector(this);
        transformation.createPhases();
        this.transformations.add(transformation);
    }

    public void registerTransformationMultiple(Consumer<PhaseCollector> groupRegisterer) {
        groupRegisterer.accept(this);
    }

    public Parser getParser() {
        return this.parser;
    }

    GLSLParser.TranslationUnitContext getRootNode() {
        return this.rootNode;
    }

    protected void addPhaseAt(TransformationPhase phase, int index) {
        List<TransformationPhase> phasesForIndex = this.phases.get(index);
        if (phasesForIndex == null) {
            phasesForIndex = new ArrayList<TransformationPhase>();
            this.phases.put(index, phasesForIndex);
        }
        phasesForIndex.add(phase);
        phase.setParent(this);
        phase.init();
    }

    private void execute(GLSLParser.TranslationUnitContext ctx) {
        this.rootNode = ctx;
        for (Transformation transformation : this.transformations) {
            transformation.resetState();
        }
        for (List list : this.phases.values()) {
            WalkPhase walkPhase;
            ProxyParseTreeListener proxyListener = new ProxyParseTreeListener(new ArrayList<ParseTreeListener>());
            for (TransformationPhase phase : list) {
                if (phase instanceof WalkPhase) {
                    walkPhase = (WalkPhase)phase;
                    if (walkPhase.isActiveBeforeWalk()) {
                        walkPhase.beforeWalk(ctx);
                    }
                    if (!walkPhase.isActiveAtWalk()) continue;
                    proxyListener.add(walkPhase);
                    continue;
                }
                if (!(phase instanceof RunPhase)) continue;
                RunPhase runPhase = (RunPhase)phase;
                if (!phase.isActive()) continue;
                runPhase.run(ctx);
            }
            if (!proxyListener.isEmpty()) {
                DynamicParseTreeWalker.DEFAULT.walk(proxyListener, (ParseTree)ctx);
            }
            for (TransformationPhase phase : list) {
                if (!(phase instanceof WalkPhase) || !(walkPhase = (WalkPhase)phase).isActiveAfterWalk()) continue;
                walkPhase.afterWalk(ctx);
            }
        }
        this.rootNode = null;
    }

    public void transformTree(GLSLParser.TranslationUnitContext ctx, BufferedTokenStream tokenStream) {
        ctx.makeLocalRoot(tokenStream);
        this.execute(ctx);
    }
}

