/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.generic;

import io.github.douira.glsl_transformer.generic.CachingIntervalSet;
import io.github.douira.glsl_transformer.generic.ExtendedContext;
import java.util.LinkedList;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.AbstractParseTreeVisitor;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;

public class PrintVisitor
extends AbstractParseTreeVisitor<Void> {
    private final LinkedList<AttributedInterval> printIntervals = new LinkedList();
    private Interval cachedInterval;
    private ExtendedContext currentRoot;

    private PrintVisitor() {
    }

    private static boolean inInterval(Interval interval, int el) {
        return interval.a <= el && interval.b >= el;
    }

    public static String printTree(BufferedTokenStream rootTokenStream, ExtendedContext tree) {
        tree.makeLocalRoot(rootTokenStream);
        return new PrintVisitor().visitAndJoin(rootTokenStream, tree, tree.getFullSourceInterval());
    }

    public String visitAndJoin(BufferedTokenStream rootTokenStream, ExtendedContext rootNode, Interval bounds) {
        this.currentRoot = rootNode;
        this.visit((ParseTree)rootNode);
        StringBuilder builder = new StringBuilder(512);
        for (AttributedInterval attributedInterval : this.printIntervals) {
            Interval interval = attributedInterval.interval();
            ExtendedContext localRoot = attributedInterval.localRoot();
            CachingIntervalSet omissionSet = localRoot.getOmissionSet();
            for (Token token : localRoot.getTokenStream().getTokens(interval.a, interval.b)) {
                int tokenIndex = token.getTokenIndex();
                if (token.getType() == -1 || tokenIndex != -1 && (localRoot == rootNode && !PrintVisitor.inInterval(bounds, tokenIndex) || !omissionSet.isTokenAllowed(token))) continue;
                builder.append(token.getText());
            }
        }
        return builder.toString();
    }

    private void addInterval(int a, int b) {
        Interval interval;
        if (a > b || a < 0 || b < 0) {
            return;
        }
        if (this.cachedInterval != null && a == this.cachedInterval.a && b == this.cachedInterval.b) {
            interval = this.cachedInterval;
        } else {
            this.cachedInterval = interval = Interval.of((int)a, (int)b);
        }
        this.addInterval(interval);
    }

    private void addInterval(Interval newInterval) {
        if (newInterval.length() == 0) {
            return;
        }
        if (!this.printIntervals.isEmpty()) {
            AttributedInterval last = this.printIntervals.getLast();
            Interval lastInterval = last.interval();
            if (this.currentRoot == last.localRoot() && (!lastInterval.disjoint(newInterval) || lastInterval.adjacent(newInterval))) {
                if (lastInterval.properlyContains(newInterval)) {
                    return;
                }
                this.printIntervals.removeLast();
                newInterval = lastInterval.union(newInterval);
            }
        }
        this.printIntervals.add(new AttributedInterval(this.currentRoot, newInterval));
    }

    public Void visitChildren(RuleNode node) {
        ExtendedContext context = (ExtendedContext)node.getRuleContext();
        Interval superInterval = context.getLargestSourceInterval();
        int fetchNext = superInterval.a;
        if (context.children != null) {
            for (ParseTree child : context.children) {
                ExtendedContext childNode;
                boolean isLocalRoot = false;
                if (child instanceof ExtendedContext && (childNode = (ExtendedContext)child).isLocalRoot()) {
                    isLocalRoot = true;
                }
                ExtendedContext previousRoot = null;
                Interval childInterval = null;
                if (isLocalRoot) {
                    previousRoot = this.currentRoot;
                    this.currentRoot = (ExtendedContext)child;
                } else {
                    childInterval = child.getSourceInterval();
                    this.addInterval(fetchNext, childInterval.a - 1);
                }
                child.accept((ParseTreeVisitor)this);
                if (isLocalRoot) {
                    this.currentRoot = previousRoot;
                    continue;
                }
                fetchNext = childInterval.b + 1;
            }
        }
        this.addInterval(fetchNext, superInterval.b);
        return null;
    }

    public Void visitTerminal(TerminalNode node) {
        this.addInterval(node.getSourceInterval());
        return null;
    }

    private record AttributedInterval(ExtendedContext localRoot, Interval interval) {
    }
}

