/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.transform;

import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.generic.EditContext;
import io.github.douira.glsl_transformer.generic.ProxyParseTreeListener;
import io.github.douira.glsl_transformer.transform.Phase;
import io.github.douira.glsl_transformer.transform.RunPhase;
import io.github.douira.glsl_transformer.transform.Transformation;
import io.github.douira.glsl_transformer.transform.WalkPhase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class PhaseCollector {
    protected EditContext editContext;
    private Parser parser;
    private List<List<Phase>> phases = new ArrayList<List<Phase>>();
    private Collection<Transformation> transformations = new ArrayList<Transformation>();

    public PhaseCollector(Parser parser) {
        this.parser = parser;
    }

    public void registerTransformation(Transformation transformation) {
        transformation.setCollector(this);
        transformation.createPhases();
        this.transformations.add(transformation);
    }

    public void registerTransformationMultiple(Consumer<PhaseCollector> groupRegisterer) {
        groupRegisterer.accept(this);
    }

    public Parser getParser() {
        return this.parser;
    }

    protected void addPhaseAt(Phase phase, int index) {
        while (this.phases.size() <= index) {
            this.phases.add(new ArrayList());
        }
        this.phases.get(index).add(phase);
        phase.setParent(this);
        phase.init();
    }

    private void execute(GLSLParser.TranslationUnitContext ctx) {
        for (Transformation transformation : this.transformations) {
            transformation.resetState();
        }
        for (List list : this.phases) {
            WalkPhase walkPhase;
            ProxyParseTreeListener proxyListener = new ProxyParseTreeListener(new ArrayList<ParseTreeListener>());
            for (Phase phase : list) {
                if (phase instanceof WalkPhase) {
                    walkPhase = (WalkPhase)phase;
                    if (walkPhase.isActiveBeforeWalk()) {
                        walkPhase.beforeWalk(ctx);
                    }
                    if (!walkPhase.isActiveAtWalk()) continue;
                    proxyListener.add(walkPhase);
                    continue;
                }
                if (!phase.isActive()) continue;
                ((RunPhase)phase).run(ctx);
            }
            if (!proxyListener.isEmpty()) {
                ParseTreeWalker.DEFAULT.walk((ParseTreeListener)proxyListener, (ParseTree)ctx);
            }
            for (Phase phase : list) {
                if (!(phase instanceof WalkPhase) || !(walkPhase = (WalkPhase)phase).isActiveAfterWalk()) continue;
                walkPhase.afterWalk(ctx);
            }
        }
    }

    public EditContext transformTree(GLSLParser.TranslationUnitContext ctx, BufferedTokenStream tokenStream) {
        this.transformTree(ctx, new EditContext((ParseTree)ctx, tokenStream));
        return this.editContext;
    }

    public void transformTree(GLSLParser.TranslationUnitContext ctx, EditContext editContext) {
        this.editContext = editContext;
        this.execute(ctx);
        editContext.finishEditing();
    }
}

