/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.generic;

import io.github.douira.glsl_transformer.generic.CachingIntervalSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;

public class EditContext {
    private Map<ParseTree, LocalRootData> localRootData = new HashMap<ParseTree, LocalRootData>();
    private Map<ParseTree, ParseTree> localRootPointers = new HashMap<ParseTree, ParseTree>();
    private boolean editingFinished = false;

    public EditContext(ParseTree root, BufferedTokenStream rootTokenStream) {
        this.registerLocalRoot(root, rootTokenStream);
    }

    public void finishEditing() {
        this.editingFinished = true;
        for (LocalRootData value : this.localRootData.values()) {
            value.omissionSet().setReadonly(true);
        }
    }

    LocalRootData getLocalRootData(ParseTree localRoot) {
        return this.localRootData.get(localRoot);
    }

    boolean isLocalRoot(ParseTree node) {
        return this.localRootData.containsKey(node);
    }

    public void registerLocalRoot(ParseTree localRoot, BufferedTokenStream tokenStream) {
        this.localRootPointers.put(localRoot, localRoot);
        this.localRootData.put(localRoot, new LocalRootData(new CachingIntervalSet(), tokenStream));
    }

    ParseTree findLocalRootAncestor(ParseTree node) {
        ParseTree localRoot = null;
        LinkedList<ParseTree> traversedAncestors = new LinkedList<ParseTree>();
        while (localRoot == null) {
            if (node == null) {
                return null;
            }
            traversedAncestors.add(node);
            localRoot = this.localRootPointers.get(node);
            node = node.getParent();
        }
        for (ParseTree traversedNode : traversedAncestors) {
            this.localRootPointers.put(traversedNode, localRoot);
        }
        return localRoot;
    }

    public void omitNodeTokens(ParseTree node) {
        if (this.editingFinished) {
            throw new IllegalStateException("Can't add intervals to editing context when editing is already finished!");
        }
        Interval interval = node.getSourceInterval();
        this.localRootData.get(this.findLocalRootAncestor(node)).omissionSet().add(interval.a, interval.b);
    }

    public record LocalRootData(CachingIntervalSet omissionSet, BufferedTokenStream tokenStream) {
    }
}

