/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer;

import io.github.douira.glsl_transformer.GLSLParserBaseVisitor;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;

public class DebugVisitor
extends GLSLParserBaseVisitor<Void> {
    private int maxDepth;

    public DebugVisitor() {
        this(Integer.MAX_VALUE);
    }

    public DebugVisitor(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public Void visitChildren(RuleNode node) {
        ParserRuleContext context = (ParserRuleContext)node.getRuleContext();
        int depth = context.getPayload().depth();
        if (depth > this.maxDepth) {
            return null;
        }
        String prefix = ". ".repeat(depth);
        int n = node.getChildCount();
        String name = node.getPayload().getClass().getSimpleName();
        if (n > 1 || name.indexOf("Expression") == -1) {
            System.out.println(prefix + "---" + name);
        }
        for (int i = 0; i < n; ++i) {
            ParseTree c = node.getChild(i);
            if (n > 1) {
                System.out.println(prefix + i + "/" + n + " in " + name);
                System.out.println(prefix + c.getText());
            }
            if (c instanceof TerminalNode) {
                TerminalNode terminal = (TerminalNode)c;
                System.out.println(prefix + terminal.getSymbol().getText());
            }
            c.accept((ParseTreeVisitor)this);
        }
        return null;
    }
}

