/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.generic;

import io.github.douira.glsl_transformer.generic.CachingIntervalSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;

public class EditContext {
    private Map<ParseTree, LocalRootData> localRoots = new HashMap<ParseTree, LocalRootData>();
    private Map<ParseTree, ParseTree> localRootCache = new HashMap<ParseTree, ParseTree>();
    private boolean editingFinished = false;

    public EditContext(ParseTree root, BufferedTokenStream rootTokenStream) {
        this.registerLocalRoot(root, rootTokenStream);
    }

    public void finishEditing() {
        this.editingFinished = true;
        for (LocalRootData value : this.localRoots.values()) {
            value.omissionSet().setReadonly(true);
        }
    }

    public LocalRootData getLocalRootData(ParseTree localRoot) {
        return this.localRoots.get(localRoot);
    }

    public void registerLocalRoot(ParseTree localRoot, BufferedTokenStream tokenStream) {
        this.localRoots.put(localRoot, new LocalRootData(new CachingIntervalSet(), tokenStream));
    }

    public void omitNodeTokens(ParseTree node) {
        if (this.editingFinished) {
            throw new IllegalStateException("Can't add intervals to editing context when editing is already finished!");
        }
        ParseTree localRoot = this.localRootCache.get(node);
        if (localRoot == null) {
            LinkedList<ParseTree> traversedParents = new LinkedList<ParseTree>();
            ParseTree ancestor = node;
            while (ancestor != null) {
                traversedParents.add(ancestor);
                localRoot = ancestor;
                ParseTree cacheResult = this.localRootCache.get(ancestor = localRoot.getParent());
                if (cacheResult == null) continue;
                localRoot = cacheResult;
                break;
            }
            for (ParseTree traversedNode : traversedParents) {
                this.localRootCache.put(traversedNode, localRoot);
            }
        }
        Interval interval = node.getSourceInterval();
        this.localRoots.get(localRoot).omissionSet().add(interval.a, interval.b);
    }

    public record LocalRootData(CachingIntervalSet omissionSet, BufferedTokenStream tokenStream) {
    }
}

