/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl;

import io.github.dmlloyd.classfile.BootstrapMethodEntry;
import io.github.dmlloyd.classfile.Opcode;
import io.github.dmlloyd.classfile.TypeKind;
import io.github.dmlloyd.classfile.constantpool.ClassEntry;
import io.github.dmlloyd.classfile.constantpool.ConstantDynamicEntry;
import io.github.dmlloyd.classfile.constantpool.ConstantPoolBuilder;
import io.github.dmlloyd.classfile.constantpool.LoadableConstantEntry;
import io.github.dmlloyd.classfile.constantpool.MemberRefEntry;
import io.github.dmlloyd.classfile.constantpool.MethodHandleEntry;
import io.github.dmlloyd.classfile.constantpool.NameAndTypeEntry;
import io.github.dmlloyd.classfile.impl.Util;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicConstantDesc;
import java.util.ArrayList;
import java.util.Objects;

public class BytecodeHelpers {
    private BytecodeHelpers() {
    }

    public static IllegalArgumentException cannotConvertException(TypeKind from, TypeKind to) {
        return new IllegalArgumentException(String.format("convert %s -> %s", new Object[]{from, to}));
    }

    public static IllegalArgumentException slotOutOfBounds(int slot) {
        return new IllegalArgumentException("Invalid slot index :".concat(Integer.toString(slot)));
    }

    public static IllegalArgumentException slotOutOfBounds(Opcode opcode, int slot) {
        return new IllegalArgumentException("Invalid slot index %d for %s".formatted(new Object[]{slot, opcode}));
    }

    public static Opcode loadOpcode(TypeKind tk, int slot) {
        return switch (tk) {
            default -> throw new IncompatibleClassChangeError();
            case TypeKind.INT, TypeKind.SHORT, TypeKind.BYTE, TypeKind.CHAR, TypeKind.BOOLEAN -> BytecodeHelpers.iload(slot);
            case TypeKind.LONG -> BytecodeHelpers.lload(slot);
            case TypeKind.DOUBLE -> BytecodeHelpers.dload(slot);
            case TypeKind.FLOAT -> BytecodeHelpers.fload(slot);
            case TypeKind.REFERENCE -> BytecodeHelpers.aload(slot);
            case TypeKind.VOID -> throw new IllegalArgumentException("void");
        };
    }

    public static Opcode aload(int slot) {
        return switch (slot) {
            case 0 -> Opcode.ALOAD_0;
            case 1 -> Opcode.ALOAD_1;
            case 2 -> Opcode.ALOAD_2;
            case 3 -> Opcode.ALOAD_3;
            default -> {
                if ((slot & 0xFFFFFF00) == 0) {
                    yield Opcode.ALOAD;
                }
                if ((slot & 0xFFFF0000) == 0) {
                    yield Opcode.ALOAD_W;
                }
                throw BytecodeHelpers.slotOutOfBounds(slot);
            }
        };
    }

    public static Opcode fload(int slot) {
        return switch (slot) {
            case 0 -> Opcode.FLOAD_0;
            case 1 -> Opcode.FLOAD_1;
            case 2 -> Opcode.FLOAD_2;
            case 3 -> Opcode.FLOAD_3;
            default -> {
                if ((slot & 0xFFFFFF00) == 0) {
                    yield Opcode.FLOAD;
                }
                if ((slot & 0xFFFF0000) == 0) {
                    yield Opcode.FLOAD_W;
                }
                throw BytecodeHelpers.slotOutOfBounds(slot);
            }
        };
    }

    public static Opcode dload(int slot) {
        return switch (slot) {
            case 0 -> Opcode.DLOAD_0;
            case 1 -> Opcode.DLOAD_1;
            case 2 -> Opcode.DLOAD_2;
            case 3 -> Opcode.DLOAD_3;
            default -> {
                if ((slot & 0xFFFFFF00) == 0) {
                    yield Opcode.DLOAD;
                }
                if ((slot & 0xFFFF0000) == 0) {
                    yield Opcode.DLOAD_W;
                }
                throw BytecodeHelpers.slotOutOfBounds(slot);
            }
        };
    }

    public static Opcode lload(int slot) {
        return switch (slot) {
            case 0 -> Opcode.LLOAD_0;
            case 1 -> Opcode.LLOAD_1;
            case 2 -> Opcode.LLOAD_2;
            case 3 -> Opcode.LLOAD_3;
            default -> {
                if ((slot & 0xFFFFFF00) == 0) {
                    yield Opcode.LLOAD;
                }
                if ((slot & 0xFFFF0000) == 0) {
                    yield Opcode.LLOAD_W;
                }
                throw BytecodeHelpers.slotOutOfBounds(slot);
            }
        };
    }

    public static Opcode iload(int slot) {
        return switch (slot) {
            case 0 -> Opcode.ILOAD_0;
            case 1 -> Opcode.ILOAD_1;
            case 2 -> Opcode.ILOAD_2;
            case 3 -> Opcode.ILOAD_3;
            default -> {
                if ((slot & 0xFFFFFF00) == 0) {
                    yield Opcode.ILOAD;
                }
                if ((slot & 0xFFFF0000) == 0) {
                    yield Opcode.ILOAD_W;
                }
                throw BytecodeHelpers.slotOutOfBounds(slot);
            }
        };
    }

    public static Opcode storeOpcode(TypeKind tk, int slot) {
        return switch (tk) {
            default -> throw new IncompatibleClassChangeError();
            case TypeKind.INT, TypeKind.SHORT, TypeKind.BYTE, TypeKind.CHAR, TypeKind.BOOLEAN -> BytecodeHelpers.istore(slot);
            case TypeKind.LONG -> BytecodeHelpers.lstore(slot);
            case TypeKind.DOUBLE -> BytecodeHelpers.dstore(slot);
            case TypeKind.FLOAT -> BytecodeHelpers.fstore(slot);
            case TypeKind.REFERENCE -> BytecodeHelpers.astore(slot);
            case TypeKind.VOID -> throw new IllegalArgumentException("void");
        };
    }

    public static Opcode astore(int slot) {
        return switch (slot) {
            case 0 -> Opcode.ASTORE_0;
            case 1 -> Opcode.ASTORE_1;
            case 2 -> Opcode.ASTORE_2;
            case 3 -> Opcode.ASTORE_3;
            default -> {
                if ((slot & 0xFFFFFF00) == 0) {
                    yield Opcode.ASTORE;
                }
                if ((slot & 0xFFFF0000) == 0) {
                    yield Opcode.ASTORE_W;
                }
                throw BytecodeHelpers.slotOutOfBounds(slot);
            }
        };
    }

    public static Opcode fstore(int slot) {
        return switch (slot) {
            case 0 -> Opcode.FSTORE_0;
            case 1 -> Opcode.FSTORE_1;
            case 2 -> Opcode.FSTORE_2;
            case 3 -> Opcode.FSTORE_3;
            default -> {
                if ((slot & 0xFFFFFF00) == 0) {
                    yield Opcode.FSTORE;
                }
                if ((slot & 0xFFFF0000) == 0) {
                    yield Opcode.FSTORE_W;
                }
                throw BytecodeHelpers.slotOutOfBounds(slot);
            }
        };
    }

    public static Opcode dstore(int slot) {
        return switch (slot) {
            case 0 -> Opcode.DSTORE_0;
            case 1 -> Opcode.DSTORE_1;
            case 2 -> Opcode.DSTORE_2;
            case 3 -> Opcode.DSTORE_3;
            default -> {
                if ((slot & 0xFFFFFF00) == 0) {
                    yield Opcode.DSTORE;
                }
                if ((slot & 0xFFFF0000) == 0) {
                    yield Opcode.DSTORE_W;
                }
                throw BytecodeHelpers.slotOutOfBounds(slot);
            }
        };
    }

    public static Opcode lstore(int slot) {
        return switch (slot) {
            case 0 -> Opcode.LSTORE_0;
            case 1 -> Opcode.LSTORE_1;
            case 2 -> Opcode.LSTORE_2;
            case 3 -> Opcode.LSTORE_3;
            default -> {
                if ((slot & 0xFFFFFF00) == 0) {
                    yield Opcode.LSTORE;
                }
                if ((slot & 0xFFFF0000) == 0) {
                    yield Opcode.LSTORE_W;
                }
                throw BytecodeHelpers.slotOutOfBounds(slot);
            }
        };
    }

    public static Opcode istore(int slot) {
        return switch (slot) {
            case 0 -> Opcode.ISTORE_0;
            case 1 -> Opcode.ISTORE_1;
            case 2 -> Opcode.ISTORE_2;
            case 3 -> Opcode.ISTORE_3;
            default -> {
                if ((slot & 0xFFFFFF00) == 0) {
                    yield Opcode.ISTORE;
                }
                if ((slot & 0xFFFF0000) == 0) {
                    yield Opcode.ISTORE_W;
                }
                throw BytecodeHelpers.slotOutOfBounds(slot);
            }
        };
    }

    public static Opcode returnOpcode(TypeKind tk) {
        return switch (tk) {
            default -> throw new IncompatibleClassChangeError();
            case TypeKind.INT, TypeKind.SHORT, TypeKind.BYTE, TypeKind.CHAR, TypeKind.BOOLEAN -> Opcode.IRETURN;
            case TypeKind.FLOAT -> Opcode.FRETURN;
            case TypeKind.LONG -> Opcode.LRETURN;
            case TypeKind.DOUBLE -> Opcode.DRETURN;
            case TypeKind.REFERENCE -> Opcode.ARETURN;
            case TypeKind.VOID -> Opcode.RETURN;
        };
    }

    public static int returnBytecode(TypeKind tk) {
        int kind = Math.max(0, tk.ordinal() - 4);
        return 172 + kind;
    }

    public static Opcode arrayLoadOpcode(TypeKind tk) {
        return switch (tk) {
            default -> throw new IncompatibleClassChangeError();
            case TypeKind.BYTE, TypeKind.BOOLEAN -> Opcode.BALOAD;
            case TypeKind.SHORT -> Opcode.SALOAD;
            case TypeKind.INT -> Opcode.IALOAD;
            case TypeKind.FLOAT -> Opcode.FALOAD;
            case TypeKind.LONG -> Opcode.LALOAD;
            case TypeKind.DOUBLE -> Opcode.DALOAD;
            case TypeKind.REFERENCE -> Opcode.AALOAD;
            case TypeKind.CHAR -> Opcode.CALOAD;
            case TypeKind.VOID -> throw new IllegalArgumentException("void not an allowable array type");
        };
    }

    public static int arrayLoadBytecode(TypeKind tk) {
        return switch (tk) {
            default -> throw new IncompatibleClassChangeError();
            case TypeKind.BYTE, TypeKind.BOOLEAN -> 51;
            case TypeKind.SHORT -> 53;
            case TypeKind.INT -> 46;
            case TypeKind.FLOAT -> 48;
            case TypeKind.LONG -> 47;
            case TypeKind.DOUBLE -> 49;
            case TypeKind.REFERENCE -> 50;
            case TypeKind.CHAR -> 52;
            case TypeKind.VOID -> throw new IllegalArgumentException("void not an allowable array type");
        };
    }

    public static Opcode arrayStoreOpcode(TypeKind tk) {
        return switch (tk) {
            default -> throw new IncompatibleClassChangeError();
            case TypeKind.BYTE, TypeKind.BOOLEAN -> Opcode.BASTORE;
            case TypeKind.SHORT -> Opcode.SASTORE;
            case TypeKind.INT -> Opcode.IASTORE;
            case TypeKind.FLOAT -> Opcode.FASTORE;
            case TypeKind.LONG -> Opcode.LASTORE;
            case TypeKind.DOUBLE -> Opcode.DASTORE;
            case TypeKind.REFERENCE -> Opcode.AASTORE;
            case TypeKind.CHAR -> Opcode.CASTORE;
            case TypeKind.VOID -> throw new IllegalArgumentException("void not an allowable array type");
        };
    }

    public static int arrayStoreBytecode(TypeKind tk) {
        return switch (tk) {
            default -> throw new IncompatibleClassChangeError();
            case TypeKind.BYTE, TypeKind.BOOLEAN -> 84;
            case TypeKind.SHORT -> 86;
            case TypeKind.INT -> 79;
            case TypeKind.FLOAT -> 81;
            case TypeKind.LONG -> 80;
            case TypeKind.DOUBLE -> 82;
            case TypeKind.REFERENCE -> 83;
            case TypeKind.CHAR -> 85;
            case TypeKind.VOID -> throw new IllegalArgumentException("void not an allowable array type");
        };
    }

    public static Opcode reverseBranchOpcode(Opcode op) {
        return switch (op) {
            case Opcode.IFEQ -> Opcode.IFNE;
            case Opcode.IFNE -> Opcode.IFEQ;
            case Opcode.IFLT -> Opcode.IFGE;
            case Opcode.IFGE -> Opcode.IFLT;
            case Opcode.IFGT -> Opcode.IFLE;
            case Opcode.IFLE -> Opcode.IFGT;
            case Opcode.IF_ICMPEQ -> Opcode.IF_ICMPNE;
            case Opcode.IF_ICMPNE -> Opcode.IF_ICMPEQ;
            case Opcode.IF_ICMPLT -> Opcode.IF_ICMPGE;
            case Opcode.IF_ICMPGE -> Opcode.IF_ICMPLT;
            case Opcode.IF_ICMPGT -> Opcode.IF_ICMPLE;
            case Opcode.IF_ICMPLE -> Opcode.IF_ICMPGT;
            case Opcode.IF_ACMPEQ -> Opcode.IF_ACMPNE;
            case Opcode.IF_ACMPNE -> Opcode.IF_ACMPEQ;
            case Opcode.IFNULL -> Opcode.IFNONNULL;
            case Opcode.IFNONNULL -> Opcode.IFNULL;
            default -> throw Util.badOpcodeKindException(op, Opcode.Kind.BRANCH);
        };
    }

    public static int reverseBranchOpcode(int bytecode) {
        return switch (bytecode) {
            case 153 -> 154;
            case 154 -> 153;
            case 155 -> 156;
            case 156 -> 155;
            case 157 -> 158;
            case 158 -> 157;
            case 159 -> 160;
            case 160 -> 159;
            case 161 -> 162;
            case 162 -> 161;
            case 163 -> 164;
            case 164 -> 163;
            case 165 -> 166;
            case 166 -> 165;
            case 198 -> 199;
            case 199 -> 198;
            default -> throw new IllegalArgumentException(String.format("Wrong opcode kind specified; found %d, expected %s", new Object[]{bytecode, Opcode.Kind.BRANCH}));
        };
    }

    public static Opcode convertOpcode(TypeKind from, TypeKind to) {
        return switch (from) {
            case TypeKind.INT -> {
                switch (to) {
                    case LONG: {
                        yield Opcode.I2L;
                    }
                    case FLOAT: {
                        yield Opcode.I2F;
                    }
                    case DOUBLE: {
                        yield Opcode.I2D;
                    }
                    case BYTE: {
                        yield Opcode.I2B;
                    }
                    case CHAR: {
                        yield Opcode.I2C;
                    }
                    case SHORT: {
                        yield Opcode.I2S;
                    }
                }
                throw BytecodeHelpers.cannotConvertException(from, to);
            }
            case TypeKind.LONG -> {
                switch (to) {
                    case FLOAT: {
                        yield Opcode.L2F;
                    }
                    case DOUBLE: {
                        yield Opcode.L2D;
                    }
                    case INT: {
                        yield Opcode.L2I;
                    }
                }
                throw BytecodeHelpers.cannotConvertException(from, to);
            }
            case TypeKind.DOUBLE -> {
                switch (to) {
                    case FLOAT: {
                        yield Opcode.D2F;
                    }
                    case LONG: {
                        yield Opcode.D2L;
                    }
                    case INT: {
                        yield Opcode.D2I;
                    }
                }
                throw BytecodeHelpers.cannotConvertException(from, to);
            }
            case TypeKind.FLOAT -> {
                switch (to) {
                    case LONG: {
                        yield Opcode.F2L;
                    }
                    case DOUBLE: {
                        yield Opcode.F2D;
                    }
                    case INT: {
                        yield Opcode.F2I;
                    }
                }
                throw BytecodeHelpers.cannotConvertException(from, to);
            }
            default -> throw BytecodeHelpers.cannotConvertException(from, to);
        };
    }

    public static TypeKind convertFromType(Opcode opcode) {
        return switch (opcode) {
            case Opcode.I2D, Opcode.I2F, Opcode.I2L, Opcode.I2B, Opcode.I2C, Opcode.I2S -> TypeKind.INT;
            case Opcode.L2D, Opcode.L2F, Opcode.L2I -> TypeKind.LONG;
            case Opcode.F2D, Opcode.F2I, Opcode.F2L -> TypeKind.FLOAT;
            case Opcode.D2F, Opcode.D2I, Opcode.D2L -> TypeKind.DOUBLE;
            default -> throw Util.badOpcodeKindException(opcode, Opcode.Kind.CONVERT);
        };
    }

    public static TypeKind convertToType(Opcode opcode) {
        return switch (opcode) {
            case Opcode.I2B -> TypeKind.BYTE;
            case Opcode.I2C -> TypeKind.CHAR;
            case Opcode.I2S -> TypeKind.SHORT;
            case Opcode.L2I, Opcode.F2I, Opcode.D2I -> TypeKind.INT;
            case Opcode.I2L, Opcode.F2L, Opcode.D2L -> TypeKind.LONG;
            case Opcode.I2F, Opcode.L2F, Opcode.D2F -> TypeKind.FLOAT;
            case Opcode.I2D, Opcode.L2D, Opcode.F2D -> TypeKind.DOUBLE;
            default -> throw Util.badOpcodeKindException(opcode, Opcode.Kind.CONVERT);
        };
    }

    public static void validateSlot(Opcode opcode, int slot, boolean load) {
        int size = opcode.sizeIfFixed();
        if (size == 1 && slot == (load ? BytecodeHelpers.intrinsicLoadSlot(opcode) : BytecodeHelpers.intrinsicStoreSlot(opcode)) || size == 2 && (slot & 0xFFFFFF00) == 0 || size == 4 && (slot & 0xFFFF0000) == 0) {
            return;
        }
        throw BytecodeHelpers.slotOutOfBounds(opcode, slot);
    }

    public static void validateSlot(int slot) {
        if ((slot & 0xFFFF0000) != 0) {
            throw BytecodeHelpers.slotOutOfBounds(slot);
        }
    }

    public static boolean validateAndIsWideIinc(int slot, int val) {
        boolean ret = false;
        if ((slot & 0xFFFFFF00) != 0) {
            BytecodeHelpers.validateSlot(slot);
            ret = true;
        }
        if ((byte)val != val) {
            if ((short)val != val) {
                throw new IllegalArgumentException("cannot encode as S2: ".concat(String.valueOf(val)));
            }
            ret = true;
        }
        return ret;
    }

    public static void validateRet(Opcode opcode, int slot) {
        if (opcode == Opcode.RET && (slot & 0xFFFFFF00) == 0 || opcode == Opcode.RET_W && (slot & 0xFFFF0000) == 0) {
            return;
        }
        Objects.requireNonNull(opcode);
        throw BytecodeHelpers.slotOutOfBounds(opcode, slot);
    }

    public static void validateMultiArrayDimensions(int value) {
        if (value < 1 || value > 255) {
            throw new IllegalArgumentException("Not a valid array dimension: ".concat(String.valueOf(value)));
        }
    }

    public static void validateSipush(int value) {
        if (value != (short)value) {
            throw new IllegalArgumentException("SIPUSH: value must be within: Short.MIN_VALUE <= value <= Short.MAX_VALUE, found: ".concat(Long.toString(value)));
        }
    }

    public static void validateBipush(int value) {
        if (value != (byte)value) {
            throw new IllegalArgumentException("BIPUSH: value must be within: Byte.MIN_VALUE <= value <= Byte.MAX_VALUE, found: ".concat(Long.toString(value)));
        }
    }

    public static MethodHandleEntry handleDescToHandleInfo(ConstantPoolBuilder constantPool, DirectMethodHandleDesc bootstrapMethod) {
        ClassEntry bsOwner = constantPool.classEntry(bootstrapMethod.owner());
        NameAndTypeEntry bsNameAndType = constantPool.nameAndTypeEntry(constantPool.utf8Entry(bootstrapMethod.methodName()), constantPool.utf8Entry(bootstrapMethod.lookupDescriptor()));
        int bsRefKind = bootstrapMethod.refKind();
        MemberRefEntry bsReference = BytecodeHelpers.toBootstrapMemberRef(constantPool, bsRefKind, bsOwner, bsNameAndType, bootstrapMethod.isOwnerInterface());
        return constantPool.methodHandleEntry(bsRefKind, bsReference);
    }

    static MemberRefEntry toBootstrapMemberRef(ConstantPoolBuilder constantPool, int bsRefKind, ClassEntry owner, NameAndTypeEntry nat, boolean isOwnerInterface) {
        return isOwnerInterface ? constantPool.interfaceMethodRefEntry(owner, nat) : (bsRefKind <= 4 ? constantPool.fieldRefEntry(owner, nat) : constantPool.methodRefEntry(owner, nat));
    }

    static ConstantDynamicEntry handleConstantDescToHandleInfo(ConstantPoolBuilder constantPool, DynamicConstantDesc<?> desc) {
        ConstantDesc[] bootstrapArgs = desc.bootstrapArgs();
        ArrayList<LoadableConstantEntry> staticArgs = new ArrayList<LoadableConstantEntry>(bootstrapArgs.length);
        for (ConstantDesc bootstrapArg : bootstrapArgs) {
            staticArgs.add(constantPool.loadableConstantEntry(bootstrapArg));
        }
        MethodHandleEntry methodHandleEntry = BytecodeHelpers.handleDescToHandleInfo(constantPool, desc.bootstrapMethod());
        BootstrapMethodEntry bme = constantPool.bsmEntry(methodHandleEntry, staticArgs);
        return constantPool.constantDynamicEntry(bme, constantPool.nameAndTypeEntry(desc.constantName(), desc.constantType()));
    }

    public static Opcode ldcOpcode(LoadableConstantEntry entry) {
        return entry.typeKind().slotSize() == 2 ? Opcode.LDC2_W : (entry.index() > 255 ? Opcode.LDC_W : Opcode.LDC);
    }

    public static ConstantDesc intrinsicConstantValue(Opcode opcode) {
        return switch (opcode) {
            case Opcode.ACONST_NULL -> ConstantDescs.NULL;
            case Opcode.ICONST_M1 -> Integer.valueOf(-1);
            case Opcode.ICONST_0 -> Integer.valueOf(0);
            case Opcode.ICONST_1 -> Integer.valueOf(1);
            case Opcode.ICONST_2 -> Integer.valueOf(2);
            case Opcode.ICONST_3 -> Integer.valueOf(3);
            case Opcode.ICONST_4 -> Integer.valueOf(4);
            case Opcode.ICONST_5 -> Integer.valueOf(5);
            case Opcode.LCONST_0 -> Long.valueOf(0L);
            case Opcode.LCONST_1 -> Long.valueOf(1L);
            case Opcode.FCONST_0 -> Float.valueOf(0.0f);
            case Opcode.FCONST_1 -> Float.valueOf(1.0f);
            case Opcode.FCONST_2 -> Float.valueOf(2.0f);
            case Opcode.DCONST_0 -> Double.valueOf(0.0);
            case Opcode.DCONST_1 -> Double.valueOf(1.0);
            default -> throw Util.badOpcodeKindException(opcode, Opcode.Kind.CONSTANT);
        };
    }

    public static TypeKind intrinsicConstantType(Opcode opcode) {
        return switch (opcode) {
            case Opcode.ACONST_NULL -> TypeKind.REFERENCE;
            case Opcode.ICONST_M1, Opcode.ICONST_0, Opcode.ICONST_1, Opcode.ICONST_2, Opcode.ICONST_3, Opcode.ICONST_4, Opcode.ICONST_5 -> TypeKind.INT;
            case Opcode.LCONST_0, Opcode.LCONST_1 -> TypeKind.LONG;
            case Opcode.FCONST_0, Opcode.FCONST_1, Opcode.FCONST_2 -> TypeKind.FLOAT;
            case Opcode.DCONST_0, Opcode.DCONST_1 -> TypeKind.DOUBLE;
            default -> throw Util.badOpcodeKindException(opcode, Opcode.Kind.CONSTANT);
        };
    }

    public static boolean isUnconditionalBranch(Opcode opcode) {
        return switch (opcode) {
            case Opcode.GOTO, Opcode.ATHROW, Opcode.GOTO_W, Opcode.LOOKUPSWITCH, Opcode.TABLESWITCH -> true;
            default -> opcode.kind() == Opcode.Kind.RETURN;
        };
    }

    public static int intrinsicLoadSlot(Opcode loadOpcode) {
        return switch (loadOpcode) {
            case Opcode.ILOAD_0, Opcode.LLOAD_0, Opcode.FLOAD_0, Opcode.DLOAD_0, Opcode.ALOAD_0 -> 0;
            case Opcode.ILOAD_1, Opcode.LLOAD_1, Opcode.FLOAD_1, Opcode.DLOAD_1, Opcode.ALOAD_1 -> 1;
            case Opcode.ILOAD_2, Opcode.LLOAD_2, Opcode.FLOAD_2, Opcode.DLOAD_2, Opcode.ALOAD_2 -> 2;
            case Opcode.ILOAD_3, Opcode.LLOAD_3, Opcode.FLOAD_3, Opcode.DLOAD_3, Opcode.ALOAD_3 -> 3;
            default -> throw Util.badOpcodeKindException(loadOpcode, Opcode.Kind.LOAD);
        };
    }

    public static int intrinsicStoreSlot(Opcode storeOpcode) {
        return switch (storeOpcode) {
            case Opcode.ISTORE_0, Opcode.LSTORE_0, Opcode.FSTORE_0, Opcode.DSTORE_0, Opcode.ASTORE_0 -> 0;
            case Opcode.ISTORE_1, Opcode.LSTORE_1, Opcode.FSTORE_1, Opcode.DSTORE_1, Opcode.ASTORE_1 -> 1;
            case Opcode.ISTORE_2, Opcode.LSTORE_2, Opcode.FSTORE_2, Opcode.DSTORE_2, Opcode.ASTORE_2 -> 2;
            case Opcode.ISTORE_3, Opcode.LSTORE_3, Opcode.FSTORE_3, Opcode.DSTORE_3, Opcode.ASTORE_3 -> 3;
            default -> throw Util.badOpcodeKindException(storeOpcode, Opcode.Kind.STORE);
        };
    }

    public static TypeKind loadType(Opcode loadOpcode) {
        return switch (loadOpcode.bytecode() & 0xFF) {
            case 21, 26, 27, 28, 29 -> TypeKind.INT;
            case 22, 30, 31, 32, 33 -> TypeKind.LONG;
            case 23, 34, 35, 36, 37 -> TypeKind.FLOAT;
            case 24, 38, 39, 40, 41 -> TypeKind.DOUBLE;
            case 25, 42, 43, 44, 45 -> TypeKind.REFERENCE;
            default -> throw Util.badOpcodeKindException(loadOpcode, Opcode.Kind.LOAD);
        };
    }

    public static TypeKind storeType(Opcode storeOpcode) {
        return switch (storeOpcode.bytecode() & 0xFF) {
            case 54, 59, 60, 61, 62 -> TypeKind.INT;
            case 55, 63, 64, 65, 66 -> TypeKind.LONG;
            case 56, 67, 68, 69, 70 -> TypeKind.FLOAT;
            case 57, 71, 72, 73, 74 -> TypeKind.DOUBLE;
            case 58, 75, 76, 77, 78 -> TypeKind.REFERENCE;
            default -> throw Util.badOpcodeKindException(storeOpcode, Opcode.Kind.STORE);
        };
    }

    public static TypeKind arrayLoadType(Opcode arrayLoadOpcode) {
        return switch (arrayLoadOpcode) {
            case Opcode.IALOAD -> TypeKind.INT;
            case Opcode.LALOAD -> TypeKind.LONG;
            case Opcode.FALOAD -> TypeKind.FLOAT;
            case Opcode.DALOAD -> TypeKind.DOUBLE;
            case Opcode.AALOAD -> TypeKind.REFERENCE;
            case Opcode.BALOAD -> TypeKind.BYTE;
            case Opcode.CALOAD -> TypeKind.CHAR;
            case Opcode.SALOAD -> TypeKind.SHORT;
            default -> throw Util.badOpcodeKindException(arrayLoadOpcode, Opcode.Kind.ARRAY_LOAD);
        };
    }

    public static TypeKind arrayStoreType(Opcode arrayStoreOpcode) {
        return switch (arrayStoreOpcode) {
            case Opcode.IASTORE -> TypeKind.INT;
            case Opcode.LASTORE -> TypeKind.LONG;
            case Opcode.FASTORE -> TypeKind.FLOAT;
            case Opcode.DASTORE -> TypeKind.DOUBLE;
            case Opcode.AASTORE -> TypeKind.REFERENCE;
            case Opcode.BASTORE -> TypeKind.BYTE;
            case Opcode.CASTORE -> TypeKind.CHAR;
            case Opcode.SASTORE -> TypeKind.SHORT;
            default -> throw Util.badOpcodeKindException(arrayStoreOpcode, Opcode.Kind.ARRAY_STORE);
        };
    }

    public static TypeKind returnType(Opcode returnOpcode) {
        return switch (returnOpcode) {
            case Opcode.IRETURN -> TypeKind.INT;
            case Opcode.LRETURN -> TypeKind.LONG;
            case Opcode.FRETURN -> TypeKind.FLOAT;
            case Opcode.DRETURN -> TypeKind.DOUBLE;
            case Opcode.ARETURN -> TypeKind.REFERENCE;
            case Opcode.RETURN -> TypeKind.VOID;
            default -> throw Util.badOpcodeKindException(returnOpcode, Opcode.Kind.RETURN);
        };
    }

    public static TypeKind operatorOperandType(Opcode operationOpcode) {
        return switch (operationOpcode) {
            case Opcode.IADD, Opcode.ISUB, Opcode.IMUL, Opcode.IDIV, Opcode.IREM, Opcode.INEG, Opcode.ISHL, Opcode.ISHR, Opcode.IUSHR, Opcode.IAND, Opcode.IOR, Opcode.IXOR, Opcode.ARRAYLENGTH -> TypeKind.INT;
            case Opcode.LADD, Opcode.LSUB, Opcode.LMUL, Opcode.LDIV, Opcode.LREM, Opcode.LNEG, Opcode.LSHL, Opcode.LSHR, Opcode.LUSHR, Opcode.LAND, Opcode.LOR, Opcode.LXOR, Opcode.LCMP -> TypeKind.LONG;
            case Opcode.FADD, Opcode.FSUB, Opcode.FMUL, Opcode.FDIV, Opcode.FREM, Opcode.FNEG, Opcode.FCMPL, Opcode.FCMPG -> TypeKind.FLOAT;
            case Opcode.DADD, Opcode.DSUB, Opcode.DMUL, Opcode.DDIV, Opcode.DREM, Opcode.DNEG, Opcode.DCMPL, Opcode.DCMPG -> TypeKind.DOUBLE;
            default -> throw Util.badOpcodeKindException(operationOpcode, Opcode.Kind.OPERATOR);
        };
    }
}

