/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl;

import io.github.dmlloyd.classfile.Annotation;
import io.github.dmlloyd.classfile.AnnotationElement;
import io.github.dmlloyd.classfile.AnnotationValue;
import io.github.dmlloyd.classfile.constantpool.DoubleEntry;
import io.github.dmlloyd.classfile.constantpool.FloatEntry;
import io.github.dmlloyd.classfile.constantpool.IntegerEntry;
import io.github.dmlloyd.classfile.constantpool.LongEntry;
import io.github.dmlloyd.classfile.constantpool.Utf8Entry;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Objects;

public record AnnotationImpl(Utf8Entry className, List<AnnotationElement> elements) implements Annotation
{
    public AnnotationImpl {
        Objects.requireNonNull(className);
        elements = List.copyOf(elements);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Annotation[");
        sb.append(this.className().stringValue());
        List<AnnotationElement> evps = this.elements();
        if (!evps.isEmpty()) {
            sb.append(' ').append(evps);
        }
        sb.append("]");
        return sb.toString();
    }

    public record OfClassImpl(Utf8Entry className) implements AnnotationValue.OfClass
    {
        @Override
        public int tag() {
            return 99;
        }
    }

    public record OfAnnotationImpl(Annotation annotation) implements AnnotationValue.OfAnnotation
    {
        @Override
        public int tag() {
            return 64;
        }
    }

    public record OfEnumImpl(Utf8Entry className, Utf8Entry constantName) implements AnnotationValue.OfEnum
    {
        @Override
        public int tag() {
            return 101;
        }
    }

    public record OfArrayImpl(List<AnnotationValue> values) implements AnnotationValue.OfArray
    {
        public OfArrayImpl {
            values = List.copyOf(values);
        }

        @Override
        public int tag() {
            return 91;
        }
    }

    public static final class OfBooleanImpl
    extends Record
    implements AnnotationValue.OfBoolean {
        private final IntegerEntry constant;

        public OfBooleanImpl(IntegerEntry constant) {
            this.constant = constant;
        }

        @Override
        public int tag() {
            return 90;
        }

        @Override
        public boolean booleanValue() {
            return this.constant().intValue() != 0;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{OfBooleanImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{OfBooleanImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{OfBooleanImpl.class, "constant", "constant"}, this, o);
        }

        @Override
        public IntegerEntry constant() {
            return this.constant;
        }
    }

    public static final class OfByteImpl
    extends Record
    implements AnnotationValue.OfByte {
        private final IntegerEntry constant;

        public OfByteImpl(IntegerEntry constant) {
            this.constant = constant;
        }

        @Override
        public int tag() {
            return 66;
        }

        @Override
        public byte byteValue() {
            return (byte)this.constant().intValue();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{OfByteImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{OfByteImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{OfByteImpl.class, "constant", "constant"}, this, o);
        }

        @Override
        public IntegerEntry constant() {
            return this.constant;
        }
    }

    public static final class OfCharImpl
    extends Record
    implements AnnotationValue.OfChar {
        private final IntegerEntry constant;

        public OfCharImpl(IntegerEntry constant) {
            this.constant = constant;
        }

        @Override
        public int tag() {
            return 67;
        }

        @Override
        public char charValue() {
            return (char)this.constant().intValue();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{OfCharImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{OfCharImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{OfCharImpl.class, "constant", "constant"}, this, o);
        }

        @Override
        public IntegerEntry constant() {
            return this.constant;
        }
    }

    public static final class OfShortImpl
    extends Record
    implements AnnotationValue.OfShort {
        private final IntegerEntry constant;

        public OfShortImpl(IntegerEntry constant) {
            this.constant = constant;
        }

        @Override
        public int tag() {
            return 83;
        }

        @Override
        public short shortValue() {
            return (short)this.constant().intValue();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{OfShortImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{OfShortImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{OfShortImpl.class, "constant", "constant"}, this, o);
        }

        @Override
        public IntegerEntry constant() {
            return this.constant;
        }
    }

    public static final class OfIntImpl
    extends Record
    implements AnnotationValue.OfInt {
        private final IntegerEntry constant;

        public OfIntImpl(IntegerEntry constant) {
            this.constant = constant;
        }

        @Override
        public int tag() {
            return 73;
        }

        @Override
        public int intValue() {
            return this.constant().intValue();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{OfIntImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{OfIntImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{OfIntImpl.class, "constant", "constant"}, this, o);
        }

        @Override
        public IntegerEntry constant() {
            return this.constant;
        }
    }

    public static final class OfLongImpl
    extends Record
    implements AnnotationValue.OfLong {
        private final LongEntry constant;

        public OfLongImpl(LongEntry constant) {
            this.constant = constant;
        }

        @Override
        public int tag() {
            return 74;
        }

        @Override
        public long longValue() {
            return this.constant().longValue();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{OfLongImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{OfLongImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{OfLongImpl.class, "constant", "constant"}, this, o);
        }

        @Override
        public LongEntry constant() {
            return this.constant;
        }
    }

    public static final class OfFloatImpl
    extends Record
    implements AnnotationValue.OfFloat {
        private final FloatEntry constant;

        public OfFloatImpl(FloatEntry constant) {
            this.constant = constant;
        }

        @Override
        public int tag() {
            return 70;
        }

        @Override
        public float floatValue() {
            return this.constant().floatValue();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{OfFloatImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{OfFloatImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{OfFloatImpl.class, "constant", "constant"}, this, o);
        }

        @Override
        public FloatEntry constant() {
            return this.constant;
        }
    }

    public static final class OfDoubleImpl
    extends Record
    implements AnnotationValue.OfDouble {
        private final DoubleEntry constant;

        public OfDoubleImpl(DoubleEntry constant) {
            this.constant = constant;
        }

        @Override
        public int tag() {
            return 68;
        }

        @Override
        public double doubleValue() {
            return this.constant().doubleValue();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{OfDoubleImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{OfDoubleImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{OfDoubleImpl.class, "constant", "constant"}, this, o);
        }

        @Override
        public DoubleEntry constant() {
            return this.constant;
        }
    }

    public static final class OfStringImpl
    extends Record
    implements AnnotationValue.OfString {
        private final Utf8Entry constant;

        public OfStringImpl(Utf8Entry constant) {
            this.constant = constant;
        }

        @Override
        public int tag() {
            return 115;
        }

        @Override
        public String stringValue() {
            return this.constant().stringValue();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{OfStringImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{OfStringImpl.class, "constant", "constant"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{OfStringImpl.class, "constant", "constant"}, this, o);
        }

        @Override
        public Utf8Entry constant() {
            return this.constant;
        }
    }

    public record AnnotationElementImpl(Utf8Entry name, AnnotationValue value) implements AnnotationElement
    {
        public AnnotationElementImpl {
            Objects.requireNonNull(name);
            Objects.requireNonNull(value);
        }

        @Override
        public String toString() {
            return String.valueOf(this.name) + "=" + String.valueOf(this.value);
        }
    }
}

