/*
 * Decompiled with CFR 0.152.
 */
package me.dkim19375.dkimbukkitcore.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.dkim19375.dkimcore.annotation.API;
import me.dkim19375.dkimcore.extension.IOFunctionsKt;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@API
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0016H\u0007J\u001a\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0007J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u00052\b\b\u0002\u0010\u001c\u001a\u00020\u001bJ\b\u0010\u001d\u001a\u00020\u001bH\u0007J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0005H\u0007J\b\u0010 \u001a\u00020\u001bH\u0007J\b\u0010!\u001a\u00020\u001bH\u0007J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\b\u0010$\u001a\u00020\u0014H\u0007J\b\u0010%\u001a\u00020\u0014H\u0007J\b\u0010&\u001a\u00020\u0014H\u0007J\b\u0010'\u001a\u00020\u0014H\u0007J\b\u0010(\u001a\u00020\u0014H\u0002J\b\u0010)\u001a\u00020\u0014H\u0007R&\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lme/dkim19375/dkimbukkitcore/config/ConfigFile;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "fileName", "", "(Lorg/bukkit/plugin/java/JavaPlugin;Ljava/lang/String;)V", "<set-?>", "Lorg/bukkit/configuration/file/FileConfiguration;", "config", "getConfig$annotations", "()V", "getConfig", "()Lorg/bukkit/configuration/file/FileConfiguration;", "configFile", "Ljava/io/File;", "getFileName", "()Ljava/lang/String;", "pluginDataFolder", "addDefaults", "", "defaults", "", "addIfDoesntExist", "key", "value", "contains", "", "ignoreDefault", "createConfig", "createSubDirectory", "name", "deleteDir", "deleteFile", "getResource", "Ljava/io/InputStream;", "reload", "reset", "save", "saveDefaultConfig", "saveResource", "wipeDirectory", "DkimBukkitCore"})
public final class ConfigFile {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final String fileName;
    @NotNull
    private final File configFile;
    @NotNull
    private FileConfiguration config;
    @NotNull
    private final File pluginDataFolder;

    public ConfigFile(@NotNull JavaPlugin plugin, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.plugin = plugin;
        this.fileName = fileName;
        String fileName2 = this.fileName;
        fileName2 = StringsKt.replace$default((String)fileName2, (char)'\\', (char)'/', (boolean)false, (int)4, null);
        this.configFile = new File(this.plugin.getDataFolder(), fileName2);
        File file = this.plugin.getDataFolder();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"plugin.dataFolder");
        this.pluginDataFolder = file;
        file = YamlConfiguration.loadConfiguration((File)this.configFile);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"loadConfiguration(configFile)");
        this.config = (FileConfiguration)file;
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    @NotNull
    public final FileConfiguration getConfig() {
        return this.config;
    }

    @API
    public static /* synthetic */ void getConfig$annotations() {
    }

    @API
    public final boolean createConfig() {
        boolean success = false;
        if (!this.configFile.exists()) {
            if (!this.pluginDataFolder.exists() && this.pluginDataFolder.mkdir()) {
                success = true;
            }
            try {
                if (this.configFile.createNewFile()) {
                    success = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                success = false;
            }
        }
        return success;
    }

    @API
    public final void addIfDoesntExist(@NotNull String key, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (this.config.getString(key) == null) {
            this.config.set(key, (Object)value);
        }
    }

    @API
    public final void addDefaults(@NotNull Map<String, ? extends Object> defaults) {
        Intrinsics.checkNotNullParameter(defaults, (String)"defaults");
        this.config.addDefaults(defaults);
    }

    @API
    public final void save() {
        this.config.save(this.configFile);
    }

    @API
    public final void reload() {
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)this.configFile);
        Intrinsics.checkNotNullExpressionValue((Object)yamlConfiguration, (String)"loadConfiguration(configFile)");
        this.config = (FileConfiguration)yamlConfiguration;
    }

    @API
    public final boolean deleteFile() {
        return this.configFile.delete();
    }

    @API
    public final boolean deleteDir() {
        return FilesKt.deleteRecursively((File)this.pluginDataFolder);
    }

    @API
    public final void reset() {
        this.deleteFile();
        IOFunctionsKt.createFileAndDirs((File)this.configFile);
    }

    @API
    public final void wipeDirectory() {
        this.deleteDir();
        Path path = this.pluginDataFolder.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"pluginDataFolder.toPath()");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"Files.createDirectories(this, *attributes)");
    }

    @API
    public final void createSubDirectory(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Path path = this.pluginDataFolder.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"pluginDataFolder.toPath()");
        Object object = new FileAttribute[]{};
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path, Arrays.copyOf(object, ((FileAttribute[])object).length)), (String)"Files.createDirectories(this, *attributes)");
        Path subDir = new File(this.pluginDataFolder, name).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)subDir, (String)"subDir");
        object = subDir;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"Files.createDirectories(this, *attributes)");
    }

    public final boolean contains(@NotNull String value, boolean ignoreDefault) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.config.contains(value, ignoreDefault);
    }

    public static /* synthetic */ boolean contains$default(ConfigFile configFile, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return configFile.contains(string, bl);
    }

    private final InputStream getResource() {
        InputStream inputStream = this.plugin.getClass().getClassLoader().getResourceAsStream(this.fileName);
        return inputStream == null ? this.plugin.getClass().getResourceAsStream(this.fileName) : inputStream;
    }

    @API
    public final void saveDefaultConfig() {
        if (!this.configFile.exists()) {
            this.saveResource();
        }
    }

    private final void saveResource() {
        InputStream resource = this.getResource();
        Path path = new File(this.pluginDataFolder, this.fileName).toPath();
        if (resource == null) {
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            IOFunctionsKt.createFileAndDirs((Path)path);
            return;
        }
        Path path2 = path.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path.parent");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"Files.createDirectories(this, *attributes)");
        Files.copy(resource, path, new CopyOption[0]);
    }
}

