/*
 * Decompiled with CFR 0.152.
 */
package me.dkim19375.dkimbukkitcore.data;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.dkim19375.dkimcore.annotation.API;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@API
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0000H\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0003H\u0007J\b\u0010\u0016\u001a\u00020\u0003H\u0007J\b\u0010\u0017\u001a\u00020\nH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0018"}, d2={"Lme/dkim19375/dkimbukkitcore/data/LocationWrapper;", "", "loc", "Lorg/bukkit/Location;", "(Lorg/bukkit/Location;)V", "world", "Lorg/bukkit/World;", "getWorld", "()Lorg/bukkit/World;", "x", "", "getX", "()I", "y", "getY", "z", "getZ", "equals", "", "other", "getDistance", "", "getLocation", "hashCode", "DkimBukkitCore"})
public final class LocationWrapper {
    private final int x;
    private final int y;
    private final int z;
    @NotNull
    private final World world;

    public LocationWrapper(@NotNull Location loc) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        this.x = loc.getBlockX();
        this.y = loc.getBlockY();
        this.z = loc.getBlockZ();
        World world = loc.getWorld();
        if (world == null) {
            throw new IllegalStateException("World must be set!");
        }
        this.world = world;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getZ() {
        return this.z;
    }

    @NotNull
    public final World getWorld() {
        return this.world;
    }

    @API
    @NotNull
    public final Location getLocation() {
        return new Location(this.world, (double)this.x + 0.5, (double)this.y, (double)this.z + 0.5);
    }

    @API
    public final double getDistance(@NotNull LocationWrapper other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getDistance(other.getLocation());
    }

    @API
    public final double getDistance(@NotNull Location other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getLocation().distance(other);
    }

    public boolean equals(@Nullable Object other) {
        Object object;
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
            return false;
        }
        if (other == null) {
            throw new NullPointerException("null cannot be cast to non-null type me.dkim19375.dkimbukkitcore.data.LocationWrapper");
        }
        LocationWrapper cfr_ignored_0 = (LocationWrapper)other;
        if (this.x != ((LocationWrapper)other).x) {
            return false;
        }
        if (this.y != ((LocationWrapper)other).y) {
            return false;
        }
        if (this.z != ((LocationWrapper)other).z) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.world.getName(), (Object)((LocationWrapper)other).world.getName());
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        result = 31 * result + this.world.hashCode();
        return result;
    }
}

