/*
 * Decompiled with CFR 0.152.
 */
package io.github.divinespear.maven.plugin;

import io.github.divinespear.maven.plugin.ConnectionMock;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.persistence.Persistence;
import org.apache.commons.lang.NullArgumentException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.StringUtils;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.internal.StandardDialectResolver;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class JpaSchemaGeneratorMojo
extends AbstractMojo {
    private final Log log = this.getLog();
    @Component
    private MavenSession session;
    @Component
    private MavenProject project;
    @Component
    private MojoExecution mojo;
    @Component
    private ArtifactResolver resolver;
    @Component
    private PluginDescriptor plugin;
    @Component
    private Settings settings;
    @Parameter(property="jpa-schema.generate.skip", required=true, defaultValue="false")
    private boolean skip = false;
    @Parameter(property="jpa-schema.generate.format", required=true, defaultValue="false")
    private boolean format = false;
    @Parameter(property="jpa-schema.generate.scan-test-classes", required=true, defaultValue="false")
    private boolean scanTestClasses = false;
    @Parameter(required=true, defaultValue="META-INF/persistence.xml")
    private String persistenceXml = "META-INF/persistence.xml";
    @Parameter(required=true, defaultValue="default")
    private String persistenceUnitName = "default";
    @Parameter(required=true, defaultValue="none")
    private String databaseAction = "none";
    @Parameter(required=true, defaultValue="none")
    private String scriptAction = "none";
    @Parameter(defaultValue="${project.build.directory}/generated-schema")
    private File outputDirectory;
    @Parameter(defaultValue="create.sql")
    private String createOutputFileName = "create.sql";
    @Parameter(defaultValue="drop.sql")
    private String dropOutputFileName = "drop.sql";
    @Parameter(defaultValue="metadata")
    private String createSourceMode = "metadata";
    @Parameter
    private File createSourceFile;
    @Parameter(defaultValue="metadata")
    private String dropSourceMode = "metadata";
    @Parameter
    private File dropSourceFile;
    @Parameter
    private String jdbcDriver;
    @Parameter
    private String jdbcUrl;
    @Parameter
    private String jdbcUser;
    @Parameter
    private String jdbcPassword;
    @Parameter
    private String databaseProductName;
    @Parameter
    private Integer databaseMajorVersion;
    @Parameter
    private Integer databaseMinorVersion;
    @Parameter
    private String namingStrategy;
    @Parameter
    private String dialect;
    @Parameter
    private String lineSeparator = System.getProperty("line.separator", "\n");
    private static final Map<String, String> LINE_SEPARATOR_MAP = new HashMap<String, String>();
    private static final URL[] EMPTY_URLS;
    private static final Pattern CREATE_DROP_PATTERN;
    private static final Pattern PATTERN_CREATE_TABLE;
    private static final Pattern PATTERN_CREATE_INDEX;
    private static final Pattern PATTERN_ALTER_TABLE;

    public boolean isSkip() {
        return this.skip;
    }

    public boolean isFormat() {
        return this.format;
    }

    public boolean isScanTestClasses() {
        return this.scanTestClasses;
    }

    public String getPersistenceXml() {
        return this.persistenceXml;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public String getDatabaseAction() {
        return this.databaseAction;
    }

    public String getScriptAction() {
        return this.scriptAction;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getCreateOutputFileName() {
        return this.createOutputFileName;
    }

    public File getCreateOutputFile() {
        return this.outputDirectory == null ? null : new File(this.outputDirectory, this.createOutputFileName);
    }

    public String getDropOutputFileName() {
        return this.dropOutputFileName;
    }

    public File getDropOutputFile() {
        return this.outputDirectory == null ? null : new File(this.outputDirectory, this.dropOutputFileName);
    }

    public String getCreateSourceMode() {
        return this.createSourceMode;
    }

    public File getCreateSourceFile() {
        return this.createSourceFile;
    }

    public String getDropSourceMode() {
        return this.dropSourceMode;
    }

    public File getDropSourceFile() {
        return this.dropSourceFile;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getJdbcUser() {
        return this.jdbcUser;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public Integer getDatabaseMajorVersion() {
        return this.databaseMajorVersion;
    }

    public Integer getDatabaseMinorVersion() {
        return this.databaseMinorVersion;
    }

    public String getNamingStrategy() {
        return this.namingStrategy;
    }

    public String getDialect() {
        return this.dialect;
    }

    public String getLineSeparator() {
        String actual = StringUtils.isEmpty((String)this.lineSeparator) ? null : LINE_SEPARATOR_MAP.get(this.lineSeparator.toUpperCase());
        return actual == null ? System.getProperty("line.separator", "\n") : actual;
    }

    private ClassLoader getProjectClassLoader() throws MojoExecutionException {
        try {
            List classfiles = this.project.getCompileClasspathElements();
            if (this.scanTestClasses) {
                classfiles.addAll(this.project.getTestClasspathElements());
            }
            ArrayList<URL> classURLs = new ArrayList<URL>(classfiles.size());
            for (String classfile : classfiles) {
                classURLs.add(new File(classfile).toURI().toURL());
            }
            ArtifactResolutionRequest sharedreq = new ArtifactResolutionRequest().setResolveRoot(true).setResolveTransitively(true).setLocalRepository(this.session.getLocalRepository()).setRemoteRepositories(this.project.getRemoteArtifactRepositories());
            ArtifactRepository repository = this.session.getLocalRepository();
            Set artifacts = this.project.getDependencyArtifacts();
            for (Artifact artifact : artifacts) {
                File file;
                ArtifactResolutionRequest request;
                ArtifactResolutionResult result;
                if ("test".equalsIgnoreCase(artifact.getScope()) || !(result = this.resolver.resolve(request = new ArtifactResolutionRequest((RepositoryRequest)sharedreq).setArtifact(artifact))).isSuccess() || (file = repository.find(artifact).getFile()) == null) continue;
                classURLs.add(file.toURI().toURL());
            }
            for (URL url : classURLs) {
                this.log.info((CharSequence)("  * classpath: " + url));
            }
            return new URLClassLoader(classURLs.toArray(EMPTY_URLS), ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            throw new MojoExecutionException("Error while creating classloader", e);
        }
    }

    private boolean isDatabaseTarget() {
        return !"none".equalsIgnoreCase(this.databaseAction);
    }

    private boolean isScriptTarget() {
        return !"none".equalsIgnoreCase(this.scriptAction);
    }

    private void generate() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("javax.persistence.schema-generation.database.action", this.databaseAction.toLowerCase());
        map.put("javax.persistence.schema-generation.scripts.action", this.scriptAction.toLowerCase());
        if (this.isScriptTarget()) {
            if (this.outputDirectory == null) {
                throw new NullArgumentException("outputDirectory is required for script generation.");
            }
            map.put("javax.persistence.schema-generation.scripts.create-target", this.getCreateOutputFile().toURI().toString());
            map.put("javax.persistence.schema-generation.scripts.drop-target", this.getDropOutputFile().toURI().toString());
        }
        map.put("javax.persistence.database-product-name", this.databaseProductName);
        map.put("javax.persistence.database-major-version", this.databaseMajorVersion == null ? null : String.valueOf(this.databaseMajorVersion));
        map.put("javax.persistence.database-minor-version", this.databaseMinorVersion == null ? null : String.valueOf(this.databaseMinorVersion));
        map.put("javax.persistence.jdbc.driver", this.jdbcDriver);
        map.put("javax.persistence.jdbc.url", this.jdbcUrl);
        map.put("javax.persistence.jdbc.user", this.jdbcUser);
        map.put("javax.persistence.jdbc.password", this.jdbcPassword);
        map.put("javax.persistence.schema-generation.create-source", this.createSourceMode);
        if (this.createSourceFile == null) {
            if (!"metadata".equals(this.createSourceMode)) {
                throw new IllegalArgumentException("create source file is required for mode " + this.createSourceMode);
            }
        } else {
            map.put("javax.persistence.schema-generation.create-script-source", this.createSourceFile.toURI().toString());
        }
        map.put("javax.persistence.schema-generation.drop-source", this.dropSourceMode);
        if (this.dropSourceFile == null) {
            if (!"metadata".equals(this.dropSourceMode)) {
                throw new IllegalArgumentException("drop source file is required for mode " + this.dropSourceMode);
            }
        } else {
            map.put("javax.persistence.schema-generation.drop-script-source", this.dropSourceFile.toURI().toString());
        }
        map.put("eclipselink.persistencexml", this.persistenceXml);
        map.put("hibernate.ejb.naming_strategy", this.namingStrategy);
        map.put("hibernate.archive.autodetection", "class,hbm");
        if (this.dialect == null && this.jdbcUrl == null) {
            DialectResolutionInfo info = new DialectResolutionInfo(){

                public String getDriverName() {
                    return null;
                }

                public int getDriverMinorVersion() {
                    return 0;
                }

                public int getDriverMajorVersion() {
                    return 0;
                }

                public String getDatabaseName() {
                    return JpaSchemaGeneratorMojo.this.databaseProductName;
                }

                public int getDatabaseMinorVersion() {
                    return JpaSchemaGeneratorMojo.this.databaseMinorVersion;
                }

                public int getDatabaseMajorVersion() {
                    return JpaSchemaGeneratorMojo.this.databaseMajorVersion;
                }
            };
            Dialect detectedDialect = StandardDialectResolver.INSTANCE.resolveDialect(info);
            this.dialect = detectedDialect.getClass().getName();
        }
        if (this.dialect != null) {
            map.put("hibernate.dialect", this.dialect);
        }
        if (!this.isDatabaseTarget() && StringUtils.isEmpty((String)this.jdbcUrl)) {
            map.put("javax.persistence.schema-generation-connection", new ConnectionMock(this.getDatabaseProductName(), this.getDatabaseMajorVersion(), this.getDatabaseMinorVersion()));
        }
        map.put("javax.persistence.transactionType", "RESOURCE_LOCAL");
        map.put("javax.persistence.jtaDataSource", null);
        map.put("javax.persistence.nonJtaDataSource", null);
        map.put("javax.persistence.validation.mode", "NONE");
        Persistence.generateSchema((String)this.persistenceUnitName, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postProcess() throws IOException {
        String linesep = this.getLineSeparator();
        List<File> files = Arrays.asList(this.getCreateOutputFile(), this.getDropOutputFile());
        for (File file : files) {
            if (file == null || !file.exists()) continue;
            File tempFile = File.createTempFile("script", null, this.getOutputDirectory());
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                PrintWriter writer = new PrintWriter(tempFile);
                try {
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        line = CREATE_DROP_PATTERN.matcher(line).replaceAll(";$1");
                        for (String s : line.split(";")) {
                            if (StringUtils.isBlank((String)s)) continue;
                            if (!(s = s.trim()).endsWith(";")) {
                                s = s + ";";
                            }
                            writer.print(this.isFormat() ? this.format(s) : s);
                            writer.print(linesep);
                        }
                    }
                    writer.flush();
                }
                finally {
                    reader.close();
                    writer.close();
                }
            }
            finally {
                file.delete();
                tempFile.renameTo(file);
            }
        }
    }

    String format(String s) {
        String linesep = this.getLineSeparator();
        s = s.replaceAll("^([^(]+\\()", "$1\r\n\t").replaceAll("\\)[^()]*$", "\r\n$0").replaceAll("((?:[^(),\\s]+|\\S\\([^)]+\\)[^),]*),)\\s*", "$1\r\n\t");
        StringBuilder builder = new StringBuilder();
        boolean completed = true;
        if (PATTERN_CREATE_TABLE.matcher(s).find()) {
            for (String it : s.split("\r\n")) {
                if (it.matches("^\\S.*$")) {
                    if (!completed) {
                        builder.append(linesep);
                        completed = true;
                    }
                    builder.append(it).append(linesep);
                    continue;
                }
                if (completed) {
                    if (it.matches("^\\s*[^(]+(?:[^(),\\s]+|\\S\\([^)]+\\)[^),]*),\\s*$")) {
                        builder.append(it).append(linesep);
                        continue;
                    }
                    builder.append(it);
                    completed = false;
                    continue;
                }
                builder.append(it.trim());
                if (!it.matches("[^)]+\\).*$")) continue;
                builder.append(linesep);
                completed = true;
            }
        } else if (PATTERN_CREATE_INDEX.matcher(s).find()) {
            for (String it : s.replaceAll("(?i)^(create(\\s+\\S+)?\\s+index\\s+\\S+)\\s*", "$1\r\n\t").split("\r\n")) {
                if (builder.length() == 0) {
                    builder.append(it).append(linesep);
                    continue;
                }
                if (completed) {
                    if (it.matches("^\\s*[^(]+(?:[^(),\\s]+|\\S\\([^)]+\\)[^),]*),\\s*$")) {
                        builder.append(it).append(linesep);
                        continue;
                    }
                    builder.append(it);
                    completed = false;
                    continue;
                }
                builder.append(it.trim());
                if (!it.matches("[^)]+\\).*$")) continue;
                builder.append(linesep);
                completed = true;
            }
            String tmp = builder.toString();
            builder.setLength(0);
            builder.append(tmp.replaceAll("(?i)(asc|desc)\\s*(on)", "$2"));
        } else if (PATTERN_ALTER_TABLE.matcher(s).find()) {
            for (String it : s.replaceAll("(?i)^(alter\\s+table\\s+\\S+)\\s*", "$1\r\n\t").replaceAll("(?i)\\)\\s*(references)", ")\r\n\t$1").split("\r\n")) {
                if (builder.length() == 0) {
                    builder.append(it).append(linesep);
                    continue;
                }
                if (completed) {
                    if (it.matches("^\\s*[^(]+(?:[^(),\\s]+|\\S\\([^)]+\\)[^),]*),\\s*$")) {
                        builder.append(it).append(linesep);
                        continue;
                    }
                    builder.append(it);
                    completed = false;
                    continue;
                }
                builder.append(it.trim());
                if (!it.matches("[^)]+\\).*$")) continue;
                builder.append(linesep);
                completed = true;
            }
        } else {
            builder.append(s);
        }
        return builder.toString().trim();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.log.info((CharSequence)"schema generation is skipped.");
            return;
        }
        if (this.outputDirectory != null && !this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        ClassLoader classLoader = this.getProjectClassLoader();
        if (StringUtils.isNotBlank((String)this.jdbcDriver)) {
            try {
                Driver driver = (Driver)classLoader.loadClass(this.jdbcDriver).newInstance();
                DriverManager.registerDriver(driver);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Dependency for driver-class " + this.jdbcDriver + " is missing!", e);
            }
        }
        Thread thread = Thread.currentThread();
        ClassLoader currentClassLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(classLoader);
            this.generate();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while running", e);
        }
        finally {
            thread.setContextClassLoader(currentClassLoader);
        }
        try {
            this.postProcess();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while post-processing script file", (Exception)e);
        }
    }

    static {
        LINE_SEPARATOR_MAP.put("CR", "\r");
        LINE_SEPARATOR_MAP.put("LF", "\n");
        LINE_SEPARATOR_MAP.put("CRLF", "\r\n");
        EMPTY_URLS = new URL[0];
        CREATE_DROP_PATTERN = Pattern.compile("((?:create|drop|alter)\\s+(?:table|view|sequence))", 2);
        PATTERN_CREATE_TABLE = Pattern.compile("(?i)^create(\\s+\\S+)?\\s+(?:table|view)");
        PATTERN_CREATE_INDEX = Pattern.compile("(?i)^create(\\s+\\S+)?\\s+index");
        PATTERN_ALTER_TABLE = Pattern.compile("(?i)^alter\\s+table");
    }
}

