/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.zxing.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ComposeShader;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.util.AttributeSet;
import android.view.View;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.zxing.camera.CameraManager;
import com.google.zxing.ResultPoint;
import java.util.Collection;
import java.util.HashSet;

public final class ViewfinderView
extends View {
    private static final int[] SCANNER_ALPHA = new int[]{0, 64, 128, 192, 255, 192, 128, 64};
    private static final long ANIMATION_DELAY = 10L;
    private static final int OPAQUE = 255;
    private static final int CORNER_RECT_WIDTH = 8;
    private static final int CORNER_RECT_HEIGHT = 40;
    private static final int SCANNER_LINE_MOVE_DISTANCE = 5;
    private static final int SCANNER_LINE_HEIGHT = 10;
    private final Paint paint;
    private Bitmap resultBitmap;
    private final int maskColor;
    private final int resultColor;
    private final int frameColor;
    private final int laserColor;
    private final int cornerColor;
    private final int resultPointColor;
    private final String labelText;
    private final int labelTextColor;
    private final float labelTextSize;
    public static int scannerStart = 0;
    public static int scannerEnd = 0;
    private Collection<ResultPoint> possibleResultPoints;
    private Collection<ResultPoint> lastPossibleResultPoints;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewfinderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.ViewfinderView);
        try {
            this.laserColor = array.getColor(R.styleable.ViewfinderView_dkLaserColor, 65280);
            this.cornerColor = array.getColor(R.styleable.ViewfinderView_dkCornerColor, 65280);
            this.frameColor = array.getColor(R.styleable.ViewfinderView_dkFrameColor, 0xFFFFFF);
            this.resultPointColor = array.getColor(R.styleable.ViewfinderView_dkResultPointColor, -1056964864);
            this.maskColor = array.getColor(R.styleable.ViewfinderView_dkMaskColor, 0x60000000);
            this.resultColor = array.getColor(R.styleable.ViewfinderView_dkResultColor, -1342177280);
            this.labelTextColor = array.getColor(R.styleable.ViewfinderView_dkLabelTextColor, -1862270977);
            this.labelText = array.getString(R.styleable.ViewfinderView_dkLabelText);
            this.labelTextSize = array.getFloat(R.styleable.ViewfinderView_dkLabelTextSize, 36.0f);
        }
        finally {
            array.recycle();
        }
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.possibleResultPoints = new HashSet<ResultPoint>(5);
    }

    public void onDraw(Canvas canvas) {
        Rect frame = CameraManager.get().getFramingRect();
        if (frame == null) {
            return;
        }
        if (scannerStart == 0 || scannerEnd == 0) {
            scannerStart = frame.top;
            scannerEnd = frame.bottom;
        }
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        this.drawExterior(canvas, frame, width, height);
        if (this.resultBitmap != null) {
            this.paint.setAlpha(255);
            canvas.drawBitmap(this.resultBitmap, (float)frame.left, (float)frame.top, this.paint);
        } else {
            this.drawFrame(canvas, frame);
            this.drawCorner(canvas, frame);
            this.drawTextInfo(canvas, frame);
            this.drawLaserScanner(canvas, frame);
            Collection<ResultPoint> currentPossible = this.possibleResultPoints;
            Collection<ResultPoint> currentLast = this.lastPossibleResultPoints;
            if (currentPossible.isEmpty()) {
                this.lastPossibleResultPoints = null;
            } else {
                this.possibleResultPoints = new HashSet<ResultPoint>(5);
                this.lastPossibleResultPoints = currentPossible;
                this.paint.setAlpha(255);
                this.paint.setColor(this.resultPointColor);
                for (ResultPoint point : currentPossible) {
                    canvas.drawCircle((float)frame.left + point.getX(), (float)frame.top + point.getY(), 6.0f, this.paint);
                }
            }
            if (currentLast != null) {
                this.paint.setAlpha(127);
                this.paint.setColor(this.resultPointColor);
                for (ResultPoint point : currentLast) {
                    canvas.drawCircle((float)frame.left + point.getX(), (float)frame.top + point.getY(), 3.0f, this.paint);
                }
            }
            this.postInvalidateDelayed(10L, frame.left, frame.top, frame.right, frame.bottom);
        }
    }

    private void drawTextInfo(Canvas canvas, Rect frame) {
        this.paint.setColor(this.labelTextColor);
        this.paint.setTextSize(this.labelTextSize);
        this.paint.setTextAlign(Paint.Align.CENTER);
        canvas.drawText(this.labelText, (float)(frame.left + frame.width() / 2), (float)(frame.top - 40), this.paint);
    }

    private void drawCorner(Canvas canvas, Rect frame) {
        this.paint.setColor(this.cornerColor);
        canvas.drawRect((float)frame.left, (float)frame.top, (float)(frame.left + 8), (float)(frame.top + 40), this.paint);
        canvas.drawRect((float)frame.left, (float)frame.top, (float)(frame.left + 40), (float)(frame.top + 8), this.paint);
        canvas.drawRect((float)(frame.right - 8), (float)frame.top, (float)frame.right, (float)(frame.top + 40), this.paint);
        canvas.drawRect((float)(frame.right - 40), (float)frame.top, (float)frame.right, (float)(frame.top + 8), this.paint);
        canvas.drawRect((float)frame.left, (float)(frame.bottom - 8), (float)(frame.left + 40), (float)frame.bottom, this.paint);
        canvas.drawRect((float)frame.left, (float)(frame.bottom - 40), (float)(frame.left + 8), (float)frame.bottom, this.paint);
        canvas.drawRect((float)(frame.right - 8), (float)(frame.bottom - 40), (float)frame.right, (float)frame.bottom, this.paint);
        canvas.drawRect((float)(frame.right - 40), (float)(frame.bottom - 8), (float)frame.right, (float)frame.bottom, this.paint);
    }

    private void drawLaserScanner(Canvas canvas, Rect frame) {
        this.paint.setColor(this.laserColor);
        LinearGradient linearGradient = new LinearGradient((float)frame.left, (float)scannerStart, (float)frame.left, (float)(scannerStart + 10), this.shadeColor(this.laserColor), this.laserColor, Shader.TileMode.MIRROR);
        RadialGradient radialGradient = new RadialGradient((float)(frame.left + frame.width() / 2), (float)(scannerStart + 5), 360.0f, this.laserColor, this.shadeColor(this.laserColor), Shader.TileMode.MIRROR);
        SweepGradient sweepGradient = new SweepGradient((float)(frame.left + frame.width() / 2), (float)(scannerStart + 10), this.shadeColor(this.laserColor), this.laserColor);
        ComposeShader composeShader = new ComposeShader((Shader)radialGradient, (Shader)linearGradient, PorterDuff.Mode.ADD);
        this.paint.setShader((Shader)radialGradient);
        if (scannerStart <= scannerEnd) {
            RectF rectF = new RectF((float)(frame.left + 20), (float)scannerStart, (float)(frame.right - 20), (float)(scannerStart + 10));
            canvas.drawOval(rectF, this.paint);
            scannerStart += 5;
        } else {
            scannerStart = frame.top;
        }
        this.paint.setShader(null);
    }

    public int shadeColor(int color2) {
        String hax = Integer.toHexString(color2);
        String result2 = "20" + hax.substring(2);
        return Integer.valueOf(result2, 16);
    }

    private void drawFrame(Canvas canvas, Rect frame) {
        this.paint.setColor(this.frameColor);
        canvas.drawRect((float)frame.left, (float)frame.top, (float)(frame.right + 1), (float)(frame.top + 2), this.paint);
        canvas.drawRect((float)frame.left, (float)(frame.top + 2), (float)(frame.left + 2), (float)(frame.bottom - 1), this.paint);
        canvas.drawRect((float)(frame.right - 1), (float)frame.top, (float)(frame.right + 1), (float)(frame.bottom - 1), this.paint);
        canvas.drawRect((float)frame.left, (float)(frame.bottom - 1), (float)(frame.right + 1), (float)(frame.bottom + 1), this.paint);
    }

    private void drawExterior(Canvas canvas, Rect frame, int width, int height) {
        this.paint.setColor(this.resultBitmap != null ? this.resultColor : this.maskColor);
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)frame.top, this.paint);
        canvas.drawRect(0.0f, (float)frame.top, (float)frame.left, (float)(frame.bottom + 1), this.paint);
        canvas.drawRect((float)(frame.right + 1), (float)frame.top, (float)width, (float)(frame.bottom + 1), this.paint);
        canvas.drawRect(0.0f, (float)(frame.bottom + 1), (float)width, (float)height, this.paint);
    }

    public void drawViewfinder() {
        this.resultBitmap = null;
        this.invalidate();
    }

    public void drawResultBitmap(Bitmap barcode) {
        this.resultBitmap = barcode;
        this.invalidate();
    }

    public void addPossibleResultPoint(ResultPoint point) {
        this.possibleResultPoints.add(point);
    }
}

