/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.videoview;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.util.UIUtils;
import com.didichuxing.doraemonkit.widget.videoview.CustomVideoView;

public class MyVideoView
extends RelativeLayout {
    private CustomVideoView videoView;
    private SeekBar seekbarProgress;
    private ImageView btnController;
    private TextView tvCurrentProgress;
    private TextView tvTotalProgress;
    private ImageView ivVolume;
    private SeekBar seekbarVolume;
    private ImageView btnScreen;
    private FrameLayout flVolume;
    private FrameLayout flLight;
    private LinearLayout llyController;
    private RelativeLayout rlContainer;
    private AudioManager mAudioManager;
    private int screenWidth;
    private int screenHeight;
    private Context mContext;
    private View videoLayout;
    private Activity mActivity;
    private int videoPos;
    private int state = 0;
    private String mVideoPath;
    private boolean isVerticalScreen = true;
    private static final int UPDATE_PROGRESS = 1;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                int totalTime;
                int currentTime = MyVideoView.this.videoView.getCurrentPosition();
                if (currentTime >= (totalTime = MyVideoView.this.videoView.getDuration() - 100)) {
                    MyVideoView.this.videoView.pause();
                    MyVideoView.this.videoView.seekTo(0);
                    MyVideoView.this.seekbarProgress.setProgress(0);
                    MyVideoView.this.btnController.setImageResource(R.drawable.dk_btn_play_style);
                    MyVideoView.this.updateTextViewFormat(MyVideoView.this.tvCurrentProgress, 0);
                    MyVideoView.this.mHandler.removeMessages(1);
                } else {
                    MyVideoView.this.seekbarProgress.setMax(totalTime);
                    MyVideoView.this.seekbarProgress.setProgress(currentTime);
                    MyVideoView.this.updateTextViewFormat(MyVideoView.this.tvCurrentProgress, currentTime);
                    MyVideoView.this.updateTextViewFormat(MyVideoView.this.tvTotalProgress, totalTime);
                    MyVideoView.this.mHandler.sendEmptyMessageDelayed(1, 100L);
                }
            }
        }
    };

    public MyVideoView(Context context) {
        super(context, null);
    }

    public MyVideoView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MyVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.init();
        this.initView();
        this.initData();
        this.initListener();
    }

    public void register(Activity activity) {
        this.mActivity = activity;
    }

    public void setVideoPath(String path) {
        this.mVideoPath = path;
        if (path.startsWith("http") || path.startsWith("https")) {
            this.videoView.setVideoURI(Uri.parse((String)path));
        } else {
            this.videoView.setVideoPath(this.mVideoPath);
        }
    }

    private void init() {
        this.screenWidth = UIUtils.getWidthPixels();
        this.screenHeight = UIUtils.getRealHeightPixels();
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
    }

    private void initView() {
        this.videoLayout = LayoutInflater.from((Context)this.mContext).inflate(R.layout.dk_video_layout, (ViewGroup)this, true);
        this.flVolume = (FrameLayout)this.videoLayout.findViewById(R.id.fl_volume);
        this.flLight = (FrameLayout)this.videoLayout.findViewById(R.id.fl_light);
        this.videoView = (CustomVideoView)this.videoLayout.findViewById(R.id.videoView);
        this.seekbarProgress = (SeekBar)this.videoLayout.findViewById(R.id.seekbar_progress);
        this.seekbarVolume = (SeekBar)this.videoLayout.findViewById(R.id.seekbar_volume);
        this.btnController = (ImageView)this.videoLayout.findViewById(R.id.btn_controller);
        this.btnScreen = (ImageView)this.videoLayout.findViewById(R.id.btn_screen);
        this.tvCurrentProgress = (TextView)this.videoLayout.findViewById(R.id.tv_currentProgress);
        this.tvTotalProgress = (TextView)this.videoLayout.findViewById(R.id.tv_totalProgress);
        this.ivVolume = (ImageView)this.videoLayout.findViewById(R.id.iv_volume);
        this.llyController = (LinearLayout)this.videoLayout.findViewById(R.id.lly_controller);
        this.rlContainer = (RelativeLayout)this.videoLayout.findViewById(R.id.rl_container);
    }

    private void initData() {
        int currentVolume = this.mAudioManager.getStreamVolume(3);
        this.seekbarVolume.setProgress(currentVolume);
    }

    private void initListener() {
        this.btnScreen.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MyVideoView.this.isVerticalScreen) {
                    MyVideoView.this.mActivity.setRequestedOrientation(0);
                } else {
                    MyVideoView.this.mActivity.setRequestedOrientation(1);
                }
            }
        });
        this.btnController.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MyVideoView.this.videoView.isPlaying()) {
                    MyVideoView.this.btnController.setImageResource(R.drawable.dk_btn_play_style);
                    MyVideoView.this.videoView.pause();
                    MyVideoView.this.mHandler.removeMessages(1);
                } else {
                    MyVideoView.this.btnController.setImageResource(R.drawable.dk_btn_pause_style);
                    MyVideoView.this.videoView.start();
                    MyVideoView.this.mHandler.sendEmptyMessage(1);
                    if (MyVideoView.this.state == 0) {
                        MyVideoView.this.state = 1;
                    }
                }
            }
        });
        this.videoView.setStateListener(new CustomVideoView.StateListener(){

            @Override
            public void changeVolumn(float detlaY) {
                if (MyVideoView.this.flVolume.getVisibility() == 8) {
                    MyVideoView.this.flVolume.setVisibility(0);
                }
                int maxVolume = MyVideoView.this.mAudioManager.getStreamMaxVolume(3);
                int currentVolume = MyVideoView.this.mAudioManager.getStreamVolume(3);
                int index = (int)(detlaY / (float)MyVideoView.this.screenHeight * (float)maxVolume * 3.0f);
                int volume = Math.max(0, currentVolume - index);
                MyVideoView.this.mAudioManager.setStreamVolume(3, volume, 0);
                MyVideoView.this.seekbarVolume.setProgress(volume);
            }

            @Override
            public void changeBrightness(float detlaY) {
                if (MyVideoView.this.flLight.getVisibility() == 8) {
                    MyVideoView.this.flLight.setVisibility(0);
                }
                WindowManager.LayoutParams wml = MyVideoView.this.mActivity.getWindow().getAttributes();
                float screenBrightness = wml.screenBrightness;
                float index = -detlaY / (float)MyVideoView.this.screenHeight / 5.0f;
                if ((screenBrightness += index) > 1.0f) {
                    screenBrightness = 1.0f;
                } else if (screenBrightness < 0.01f) {
                    screenBrightness = 0.01f;
                }
                wml.screenBrightness = screenBrightness;
                MyVideoView.this.mActivity.getWindow().setAttributes(wml);
            }

            @Override
            public void hideHint() {
                if (MyVideoView.this.flLight.getVisibility() == 0) {
                    MyVideoView.this.flLight.setVisibility(8);
                }
                if (MyVideoView.this.flVolume.getVisibility() == 0) {
                    MyVideoView.this.flVolume.setVisibility(8);
                }
            }
        });
        this.seekbarVolume.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                MyVideoView.this.mAudioManager.setStreamVolume(3, progress, 0);
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        this.seekbarProgress.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                MyVideoView.this.updateTextViewFormat(MyVideoView.this.tvCurrentProgress, progress);
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                MyVideoView.this.mHandler.removeMessages(1);
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                if (MyVideoView.this.state != 0) {
                    MyVideoView.this.mHandler.sendEmptyMessage(1);
                }
                MyVideoView.this.videoView.seekTo(seekBar.getProgress());
            }
        });
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (newConfig.orientation == 1) {
            this.isVerticalScreen = true;
            this.ivVolume.setVisibility(8);
            this.seekbarVolume.setVisibility(8);
            this.setVideoViewScale(-1, UIUtils.dp2px(290.0f));
            this.mActivity.getWindow().clearFlags(1024);
            this.mActivity.getWindow().addFlags(2048);
        } else {
            this.isVerticalScreen = false;
            this.ivVolume.setVisibility(0);
            this.seekbarVolume.setVisibility(0);
            this.setVideoViewScale(-1, -1);
            this.mActivity.getWindow().clearFlags(2048);
            this.mActivity.getWindow().addFlags(1024);
        }
    }

    public void setVideoViewScale(int width, int height) {
        ViewGroup.LayoutParams videoViewLayoutParams = this.videoView.getLayoutParams();
        videoViewLayoutParams.width = width;
        videoViewLayoutParams.height = height;
        this.videoView.setLayoutParams(videoViewLayoutParams);
        RelativeLayout.LayoutParams rlContainerLayoutParams = (RelativeLayout.LayoutParams)this.rlContainer.getLayoutParams();
        rlContainerLayoutParams.width = width;
        rlContainerLayoutParams.height = height;
        this.rlContainer.setLayoutParams((ViewGroup.LayoutParams)rlContainerLayoutParams);
    }

    private void updateTextViewFormat(TextView tv, int m) {
        int second = m / 1000;
        int hour = second / 3600;
        int minute = second % 3600 / 60;
        int ss = second % 60;
        String result2 = hour != 0 ? String.format("%02d:%02d:%02d", hour, minute, ss) : String.format("%02d:%02d", minute, ss);
        tv.setText((CharSequence)result2);
    }

    public void onPause() {
        this.videoPos = this.videoView.getCurrentPosition();
        this.videoView.stopPlayback();
        this.mHandler.removeMessages(1);
    }

    public void onResume() {
        this.videoView.seekTo(this.videoPos);
        this.videoView.resume();
    }

    public void setProgressBg(Drawable drawable2) {
        this.seekbarProgress.setProgressDrawable(drawable2);
    }

    public void setVolumeBg(Drawable drawable2) {
        this.seekbarVolume.setProgressDrawable(drawable2);
    }
}

