/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.tableview.component;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import com.didichuxing.doraemonkit.widget.tableview.TableConfig;
import com.didichuxing.doraemonkit.widget.tableview.TableMeasurer;
import com.didichuxing.doraemonkit.widget.tableview.TableParser;
import com.didichuxing.doraemonkit.widget.tableview.TableProvider;
import com.didichuxing.doraemonkit.widget.tableview.bean.Column;
import com.didichuxing.doraemonkit.widget.tableview.bean.TableData;
import com.didichuxing.doraemonkit.widget.tableview.bean.TableInfo;
import com.didichuxing.doraemonkit.widget.tableview.component.TableTitle;
import com.didichuxing.doraemonkit.widget.tableview.component.YSequence;
import com.didichuxing.doraemonkit.widget.tableview.intface.ISelectFormat;
import com.didichuxing.doraemonkit.widget.tableview.intface.ITableTitle;
import com.didichuxing.doraemonkit.widget.tableview.listener.OnColumnClickListener;
import com.didichuxing.doraemonkit.widget.tableview.listener.OnTableChangeListener;
import com.didichuxing.doraemonkit.widget.tableview.style.FontStyle;
import com.didichuxing.doraemonkit.widget.tableview.utils.MatrixHelper;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class SmartTable<T>
extends View
implements OnTableChangeListener {
    private YSequence<T> yAxis;
    private ITableTitle tableTitle;
    private TableProvider<T> provider;
    private Rect showRect;
    private Rect tableRect;
    private TableConfig config = TableConfig.getInstance();
    private TableParser<T> parser;
    private TableData<T> tableData;
    private int defaultHeight = 300;
    private int defaultWidth = 300;
    private TableMeasurer<T> measurer;
    protected Paint paint;
    private MatrixHelper matrixHelper;
    private boolean isExactly = true;
    private AtomicBoolean isNotifying = new AtomicBoolean(false);
    private boolean isYSequenceRight;

    public SmartTable(Context context) {
        super(context);
        this.init();
    }

    public SmartTable(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SmartTable(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        FontStyle.setDefaultTextSpSize(this.getContext(), 13);
        this.paint = new Paint(1);
        this.showRect = new Rect();
        this.tableRect = new Rect();
        this.yAxis = new YSequence();
        this.parser = new TableParser();
        this.provider = new TableProvider();
        this.config.setPaint(this.paint);
        this.measurer = new TableMeasurer();
        this.tableTitle = new TableTitle();
        this.tableTitle.setDirection(1);
        this.matrixHelper = new MatrixHelper(this.getContext());
        this.matrixHelper.setOnTableChangeListener(this);
        this.matrixHelper.register(this.provider);
        this.matrixHelper.setOnInterceptListener(this.provider.getOperation());
    }

    protected void onDraw(Canvas canvas) {
        if (!this.isNotifying.get()) {
            Rect rect;
            this.setScrollY(0);
            this.showRect.set(this.getPaddingLeft(), this.getPaddingTop(), this.getWidth() - this.getPaddingRight(), this.getHeight() - this.getPaddingBottom());
            if (this.tableData != null && (rect = this.tableData.getTableInfo().getTableRect()) != null) {
                if (this.config.isShowTableTitle()) {
                    this.measurer.measureTableTitle(this.tableData, this.tableTitle, this.showRect);
                }
                this.tableRect.set(rect);
                Rect scaleRect = this.matrixHelper.getZoomProviderRect(this.showRect, this.tableRect, this.tableData.getTableInfo());
                if (this.config.isShowTableTitle()) {
                    this.tableTitle.onMeasure(scaleRect, this.showRect, this.config);
                    this.tableTitle.onDraw(canvas, this.showRect, this.tableData.getTableName(), this.config);
                }
                if (this.config.isShowYSequence()) {
                    this.yAxis.onMeasure(scaleRect, this.showRect, this.config);
                    if (this.isYSequenceRight) {
                        canvas.save();
                        canvas.translate((float)this.showRect.width(), 0.0f);
                        this.yAxis.onDraw(canvas, this.showRect, this.tableData, this.config);
                        canvas.restore();
                    } else {
                        this.yAxis.onDraw(canvas, this.showRect, this.tableData, this.config);
                    }
                }
                if (this.isYSequenceRight) {
                    canvas.save();
                    canvas.translate((float)(-this.yAxis.getWidth()), 0.0f);
                    this.provider.onDraw(canvas, scaleRect, this.showRect, this.tableData);
                    canvas.restore();
                } else {
                    this.provider.onDraw(canvas, scaleRect, this.showRect, this.tableData);
                }
            }
        }
    }

    private void drawGridBackground(Canvas canvas, Rect showRect, Rect scaleRect) {
        this.config.contentGridStyle.fillPaint(this.paint);
        canvas.drawRect((float)Math.max(showRect.left, scaleRect.left), (float)Math.max(showRect.top, scaleRect.top), (float)Math.min(showRect.right, scaleRect.right), (float)Math.min(scaleRect.bottom, showRect.bottom), this.paint);
    }

    public TableConfig getConfig() {
        return this.config;
    }

    public void setTableData(TableData<T> tableData) {
        if (tableData != null) {
            this.tableData = tableData;
            this.notifyDataChanged();
        }
    }

    public ITableTitle getTableTitle() {
        return this.tableTitle;
    }

    public void notifyDataChanged() {
        if (this.tableData != null) {
            this.config.setPaint(this.paint);
            this.isNotifying.set(true);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    SmartTable.this.parser.parse(SmartTable.this.tableData);
                    TableInfo info = SmartTable.this.measurer.measure(SmartTable.this.tableData, SmartTable.this.getWidth() - SmartTable.this.getPaddingRight(), SmartTable.this.getHeight() - SmartTable.this.getPaddingBottom());
                    SmartTable.this.yAxis.setWidth(info.getyAxisWidth());
                    SmartTable.this.requestReMeasure();
                    SmartTable.this.postInvalidate();
                    SmartTable.this.isNotifying.set(false);
                }
            }).start();
        }
    }

    public void addData(final List<T> t, final boolean isFoot) {
        if (t != null && t.size() > 0) {
            this.isNotifying.set(true);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    SmartTable.this.parser.addData(SmartTable.this.tableData, t, isFoot);
                    SmartTable.this.measurer.measure(SmartTable.this.tableData, SmartTable.this.getWidth() - SmartTable.this.getPaddingRight(), SmartTable.this.getHeight() - SmartTable.this.getPaddingBottom());
                    SmartTable.this.requestReMeasure();
                    SmartTable.this.postInvalidate();
                    SmartTable.this.isNotifying.set(false);
                }
            }).start();
        }
    }

    public void invalidate() {
        if (!this.isNotifying.get()) {
            super.invalidate();
        }
    }

    private void requestReMeasure() {
        if (!this.isExactly && this.getMeasuredHeight() != 0 && this.tableData != null && this.tableData.getTableInfo().getTableRect() != null) {
            int defaultHeight = this.tableData.getTableInfo().getTableRect().height() + this.getPaddingTop();
            int defaultWidth = this.tableData.getTableInfo().getTableRect().width();
            int[] realSize = new int[2];
            this.getLocationInWindow(realSize);
            DisplayMetrics dm = this.getContext().getResources().getDisplayMetrics();
            int screenWidth = dm.widthPixels;
            int screenHeight = dm.heightPixels;
            int maxWidth = screenWidth - realSize[0];
            int maxHeight = screenHeight - realSize[1];
            defaultHeight = Math.min(defaultHeight, maxHeight);
            defaultWidth = Math.min(defaultWidth, maxWidth);
            if (this.defaultHeight != defaultHeight || this.defaultWidth != defaultWidth) {
                this.defaultHeight = defaultHeight;
                this.defaultWidth = defaultWidth;
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        SmartTable.this.requestLayout();
                    }
                });
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
        this.requestReMeasure();
    }

    private int measureWidth(int widthMeasureSpec) {
        int result2;
        int specMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int specSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (specMode == 0x40000000) {
            result2 = specSize;
        } else {
            this.isExactly = false;
            result2 = this.defaultWidth;
            if (specMode == Integer.MIN_VALUE) {
                result2 = Math.min(result2, specSize);
            }
        }
        return result2;
    }

    private int measureHeight(int measureSpec) {
        int result2;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result2 = specSize;
        } else {
            this.isExactly = false;
            result2 = this.defaultHeight;
            if (specMode == Integer.MIN_VALUE) {
                result2 = Math.min(result2, specSize);
            }
        }
        return result2;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.matrixHelper.handlerTouchEvent(event);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        this.matrixHelper.onDisallowInterceptEvent(this, event);
        return super.dispatchTouchEvent(event);
    }

    @Override
    public void onTableChanged(float scale, float translateX, float translateY) {
        if (this.tableData != null) {
            this.config.setZoom(scale);
            this.tableData.getTableInfo().setZoom(scale);
            this.invalidate();
        }
    }

    public OnColumnClickListener getOnColumnClickListener() {
        return this.provider.getOnColumnClickListener();
    }

    public void setOnColumnClickListener(OnColumnClickListener onColumnClickListener) {
        this.provider.setOnColumnClickListener(onColumnClickListener);
    }

    public void setSortColumn(Column column, boolean isReverse) {
        if (this.tableData != null && column != null) {
            this.tableData.setSortColumn(column);
            this.setTableData(this.tableData);
        }
    }

    public Rect getShowRect() {
        return this.showRect;
    }

    public TableProvider<T> getProvider() {
        return this.provider;
    }

    public TableData<T> getTableData() {
        return this.tableData;
    }

    public void setZoom(boolean zoom) {
        this.matrixHelper.setCanZoom(zoom);
        this.invalidate();
    }

    public void setZoom(boolean zoom, float maxZoom, float minZoom) {
        this.matrixHelper.setCanZoom(zoom);
        this.matrixHelper.setMinZoom(minZoom);
        this.matrixHelper.setMaxZoom(maxZoom);
        this.invalidate();
    }

    public MatrixHelper getMatrixHelper() {
        return this.matrixHelper;
    }

    public void setSelectFormat(ISelectFormat selectFormat) {
        this.provider.setSelectFormat(selectFormat);
    }

    public int computeHorizontalScrollRange() {
        int contentWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int scrollRange = this.matrixHelper.getZoomRect().right;
        int scrollX = -this.matrixHelper.getZoomRect().right;
        int overScrollRight = Math.max(0, scrollRange - contentWidth);
        if (scrollX < 0) {
            scrollRange -= scrollX;
        } else if (scrollX > overScrollRight) {
            scrollRange += scrollX - overScrollRight;
        }
        return scrollRange;
    }

    public boolean canScrollVertically(int direction) {
        if (direction < 0) {
            return this.matrixHelper.getZoomRect().top != 0;
        }
        return this.matrixHelper.getZoomRect().bottom > this.matrixHelper.getOriginalRect().bottom;
    }

    public int computeHorizontalScrollOffset() {
        return Math.max(0, -this.matrixHelper.getZoomRect().top);
    }

    public int computeHorizontalScrollExtent() {
        return super.computeHorizontalScrollExtent();
    }

    public int computeVerticalScrollRange() {
        int contentHeight = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
        int scrollRange = this.matrixHelper.getZoomRect().bottom;
        int scrollY = -this.matrixHelper.getZoomRect().left;
        int overScrollBottom = Math.max(0, scrollRange - contentHeight);
        if (scrollY < 0) {
            scrollRange -= scrollY;
        } else if (scrollY > overScrollBottom) {
            scrollRange += scrollY - overScrollBottom;
        }
        return scrollRange;
    }

    public int computeVerticalScrollOffset() {
        return Math.max(0, -this.matrixHelper.getZoomRect().left);
    }

    public int computeVerticalScrollExtent() {
        return super.computeVerticalScrollExtent();
    }

    public YSequence getYSequence() {
        return this.yAxis;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.tableData != null && this.getContext() != null && ((Activity)this.getContext()).isFinishing()) {
            this.release();
        }
    }

    private void release() {
        this.matrixHelper.unRegisterAll();
        this.measurer = null;
        this.provider = null;
        this.matrixHelper = null;
        this.provider = null;
        if (this.tableData != null) {
            this.tableData.clear();
            this.tableData = null;
        }
        this.yAxis = null;
    }

    public boolean isYSequenceRight() {
        return this.isYSequenceRight;
    }

    public void setYSequenceRight(boolean YSequenceRight) {
        this.isYSequenceRight = YSequenceRight;
    }
}

