/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.widget.chart;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import com.didichuxing.doraemonkit.R;

public class BarChart
extends LinearLayout {
    private TextView markFirst;
    private TextView markSecond;
    private TextView markThird;
    private View getValue;
    private View postValue;
    private View lineEnd;

    public BarChart(Context context) {
        super(context, null);
    }

    public BarChart(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public BarChart(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        View inflate = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.dk_item_bar_chart, (ViewGroup)this, true);
        this.markFirst = (TextView)inflate.findViewById(R.id.mark_first);
        this.markSecond = (TextView)inflate.findViewById(R.id.mark_second);
        this.markThird = (TextView)inflate.findViewById(R.id.mark_third);
        this.postValue = this.findViewById(R.id.post_value);
        this.getValue = this.findViewById(R.id.get_value);
        this.lineEnd = this.findViewById(R.id.solid_line_end);
    }

    public void setData(int postNumber, @ColorInt int postColor, int getNumber, @ColorInt int getColor) {
        int max = postNumber > getNumber ? postNumber : getNumber;
        max = max + 10 - max % 10;
        float proportion = this.calculationProportion(max);
        this.markFirst.setText((CharSequence)"0");
        this.markThird.setText((CharSequence)String.valueOf(max));
        this.markSecond.setText((CharSequence)String.valueOf(max / 2));
        this.postValue.setBackgroundColor(postColor);
        ViewGroup.LayoutParams layoutParams = this.postValue.getLayoutParams();
        layoutParams.width = (int)(proportion * (float)postNumber);
        this.postValue.setLayoutParams(layoutParams);
        layoutParams = this.getValue.getLayoutParams();
        layoutParams.width = (int)(proportion * (float)getNumber);
        this.getValue.setBackgroundColor(getColor);
    }

    private float calculationProportion(float max) {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.lineEnd.getLayoutParams();
        return (float)layoutParams.leftMargin / max;
    }
}

