/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import android.content.SharedPreferences;
import androidx.annotation.Nullable;
import com.didichuxing.doraemonkit.util.Utils;

public class DoKitSPUtil {
    private static final String SHARED_PREFS_DORAEMON = "shared_prefs_doraemon";

    private static SharedPreferences getSharedPrefs() {
        return DoKitSPUtil.getSharedPrefs(SHARED_PREFS_DORAEMON);
    }

    @Nullable
    public static SharedPreferences getSharedPrefs(String name) {
        return Utils.getApp().getSharedPreferences(name, 0);
    }

    public static String getString(String key, String defVal) {
        return DoKitSPUtil.getSharedPrefs().getString(key, defVal);
    }

    public static void putString(String key, String value) {
        DoKitSPUtil.putString(SHARED_PREFS_DORAEMON, key, value);
    }

    public static void putString(String table, String key, String value) {
        try {
            if (DoKitSPUtil.getSharedPrefs(table) != null) {
                if (key.equals(SHARED_PREFS_DORAEMON)) {
                    DoKitSPUtil.getSharedPrefs(table).edit().putString(key, value).commit();
                } else {
                    DoKitSPUtil.getSharedPrefs(table).edit().putString(key, value).apply();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void putBoolean(String key, boolean value) {
        DoKitSPUtil.putBoolean(SHARED_PREFS_DORAEMON, key, value);
    }

    public static void putBoolean(String table, String key, boolean value) {
        try {
            if (DoKitSPUtil.getSharedPrefs(table) != null) {
                if (key.equals("APP_HEALTH")) {
                    DoKitSPUtil.getSharedPrefs(table).edit().putBoolean(key, value).commit();
                } else {
                    DoKitSPUtil.getSharedPrefs(table).edit().putBoolean(key, value).apply();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean getBoolean(String key, boolean defVal) {
        return DoKitSPUtil.getSharedPrefs().getBoolean(key, defVal);
    }

    public static void putInt(String key, int value) {
        DoKitSPUtil.putInt(SHARED_PREFS_DORAEMON, key, value);
    }

    public static void putInt(String table, String key, Integer value) {
        try {
            DoKitSPUtil.getSharedPrefs(table).edit().putInt(key, value.intValue()).apply();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getInt(String key, int defVal) {
        return DoKitSPUtil.getSharedPrefs().getInt(key, defVal);
    }

    public static void putFloat(String table, String key, Float value) {
        try {
            DoKitSPUtil.getSharedPrefs(table).edit().putFloat(key, value.floatValue()).apply();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void putFloat(String key, Float value) {
        try {
            DoKitSPUtil.getSharedPrefs(SHARED_PREFS_DORAEMON).edit().putFloat(key, value.floatValue()).apply();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static float getFloat(String key, Float value) {
        return DoKitSPUtil.getSharedPrefs().getFloat(key, value.floatValue());
    }

    public static void putLong(String table, String key, Long value) {
        try {
            DoKitSPUtil.getSharedPrefs(table).edit().putLong(key, value.longValue()).apply();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

