/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.util;

import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class DoKitJsonUtil {
    private static final String TAG = "JsonUtil";
    private static final Gson gson;

    public static String jsonFromObject(Object object) {
        if (object == null) {
            return "{}";
        }
        try {
            return gson.toJson(object);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "{}";
        }
    }

    public static <T> T objectFromJson(String json, Class<T> klass) {
        if (TextUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        if (klass == null) {
            return null;
        }
        try {
            return (T)gson.fromJson(json, klass);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> ArrayList<T> jsonToList(String json, Class<T> classOfT) {
        ArrayList<Object> listOfT = new ArrayList<Object>();
        if (classOfT.isPrimitive()) {
            Type type = new TypeToken<ArrayList<JsonPrimitive>>(){}.getType();
            ArrayList jsonObjs = (ArrayList)gson.fromJson(json, type);
            for (JsonPrimitive jsonObj : jsonObjs) {
                listOfT.add(gson.fromJson((JsonElement)jsonObj, classOfT));
            }
        } else {
            Type type = new TypeToken<ArrayList<JsonObject>>(){}.getType();
            ArrayList jsonObjs = (ArrayList)gson.fromJson(json, type);
            for (JsonObject jsonObj : jsonObjs) {
                listOfT.add(gson.fromJson((JsonElement)jsonObj, classOfT));
            }
        }
        return listOfT;
    }

    public static boolean isEmpty(String json) {
        if (TextUtils.isEmpty((CharSequence)json)) {
            return true;
        }
        return TextUtils.equals((CharSequence)json, (CharSequence)"{}");
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        gson = builder.create();
    }
}

