/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.viewcheck;

import android.accessibilityservice.AccessibilityService;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Parcelable;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.didichuxing.doraemonkit.util.LogHelper;

public class DebugAccessibilityService
extends AccessibilityService {
    private static final String TAG = "DebugAccessibilityService";

    protected void onServiceConnected() {
        super.onServiceConnected();
    }

    private boolean isActivityEvent(AccessibilityEvent event) {
        ComponentName activityComponentName = new ComponentName(event.getPackageName().toString(), event.getClassName().toString());
        try {
            ActivityInfo info = this.getPackageManager().getActivityInfo(activityComponentName, 0);
            if (info != null) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            LogHelper.e(TAG, e.toString());
            return false;
        }
        return true;
    }

    public void onAccessibilityEvent(AccessibilityEvent event) {
        CharSequence pkgName = event.getPackageName();
        if (pkgName == null) {
            return;
        }
        if (!pkgName.equals(this.getPackageName())) {
            return;
        }
        if (event.getEventType() != 32) {
            return;
        }
        if (!this.isActivityEvent(event)) {
            return;
        }
        AccessibilityNodeInfo info = event.getSource();
        if (info == null) {
            return;
        }
        Intent intent = new Intent("action_accessibility_update");
        intent.putExtra("accessibility_data", (Parcelable)info);
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).sendBroadcast(intent);
    }

    public void onInterrupt() {
        LogHelper.d(TAG, "onInterrupt");
    }
}

