/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.toolpanel.decoration;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.DimenRes;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.didichuxing.doraemonkit.kit.toolpanel.decoration.FlexibleDividerDecoration;

public class VerticalDividerItemDecoration
extends FlexibleDividerDecoration {
    private MarginProvider mMarginProvider;

    protected VerticalDividerItemDecoration(Builder builder) {
        super(builder);
        this.mMarginProvider = builder.mMarginProvider;
    }

    @Override
    protected Rect getDividerBound(int position, RecyclerView parent, View child) {
        Rect bounds = new Rect(0, 0, 0, 0);
        int transitionX = (int)ViewCompat.getTranslationX((View)child);
        int transitionY = (int)ViewCompat.getTranslationY((View)child);
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
        bounds.top = child.getTop() + transitionY;
        bounds.bottom = child.getBottom() + transitionY;
        int dividerSize = this.getDividerSize(position, parent);
        if (this.mDividerType == FlexibleDividerDecoration.DividerType.DRAWABLE || this.mDividerType == FlexibleDividerDecoration.DividerType.SPACE) {
            if (this.alignTopEdge(parent, position)) {
                bounds.top += this.mMarginProvider.dividerTopMargin(position, parent);
            }
            if (this.alignBottomEdge(parent, position)) {
                bounds.bottom -= this.mMarginProvider.dividerBottomMargin(position, parent);
            }
            bounds.left = child.getRight() + params.rightMargin + transitionX;
            bounds.right = bounds.left + dividerSize;
        } else {
            int halfSize = dividerSize / 2;
            bounds.right = bounds.left = child.getRight() + params.rightMargin + halfSize + transitionX;
        }
        if (this.mPositionInsideItem) {
            bounds.left -= dividerSize;
            bounds.right -= dividerSize;
        }
        return bounds;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean alignTopEdge(RecyclerView parent, int position) {
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            GridLayoutManager manager = (GridLayoutManager)layoutManager;
            GridLayoutManager.SpanSizeLookup lookup = manager.getSpanSizeLookup();
            int spanCount = manager.getSpanCount();
            if (manager.getOrientation() == 1) {
                if (manager.getReverseLayout()) {
                    if (lookup.getSpanGroupIndex(position, spanCount) != lookup.getSpanGroupIndex(parent.getAdapter().getItemCount() - 1, spanCount)) return false;
                    return true;
                }
                if (lookup.getSpanGroupIndex(position, spanCount) != 0) return false;
                return true;
            }
            if (lookup.getSpanIndex(position, spanCount) != 0) return false;
            return true;
        }
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            StaggeredGridLayoutManager manager = (StaggeredGridLayoutManager)layoutManager;
            StaggeredGridLayoutManager.LayoutParams params = (StaggeredGridLayoutManager.LayoutParams)manager.findViewByPosition(position).getLayoutParams();
            int spanCount = manager.getSpanCount();
            int spanIndex = params.getSpanIndex();
            if (manager.getOrientation() == 1) {
                if (manager.getReverseLayout()) {
                    int[] lastPosition = manager.findLastVisibleItemPositions(null);
                    boolean hasTop = false;
                    for (int p : lastPosition) {
                        StaggeredGridLayoutManager.LayoutParams params1;
                        if (p == position || p == -1 || (params1 = (StaggeredGridLayoutManager.LayoutParams)manager.findViewByPosition(p).getLayoutParams()).getSpanIndex() != spanIndex) continue;
                        return false;
                    }
                    if (hasTop) return false;
                    return true;
                }
                if (position >= spanCount) return false;
                return true;
            }
            if (params.getSpanIndex() != 0) return false;
            return true;
        }
        if (!(layoutManager instanceof LinearLayoutManager)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean alignBottomEdge(RecyclerView parent, int position) {
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            GridLayoutManager manager = (GridLayoutManager)layoutManager;
            GridLayoutManager.SpanSizeLookup lookup = manager.getSpanSizeLookup();
            int spanCount = manager.getSpanCount();
            int itemCount = parent.getAdapter().getItemCount();
            if (manager.getOrientation() == 1) {
                if (manager.getReverseLayout()) {
                    if (lookup.getSpanGroupIndex(position, spanCount) != 0) return false;
                    return true;
                }
                int lastRowFirstPosition = 0;
                for (int i = itemCount - 1; i >= 0; --i) {
                    if (lookup.getSpanIndex(i, spanCount) != 0) continue;
                    lastRowFirstPosition = i;
                    break;
                }
                if (position < lastRowFirstPosition) return false;
                return true;
            }
            if (this.positionTotalSpanSize(manager, position) != spanCount) return false;
            return true;
        }
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            StaggeredGridLayoutManager manager = (StaggeredGridLayoutManager)layoutManager;
            StaggeredGridLayoutManager.LayoutParams params = (StaggeredGridLayoutManager.LayoutParams)manager.findViewByPosition(position).getLayoutParams();
            int spanCount = manager.getSpanCount();
            int spanIndex = params.getSpanIndex();
            if (manager.getOrientation() == 1) {
                if (manager.getReverseLayout()) {
                    if (position >= spanCount) return false;
                    return true;
                }
                int[] lastPosition = manager.findLastVisibleItemPositions(null);
                boolean hasBottom = false;
                for (int p : lastPosition) {
                    StaggeredGridLayoutManager.LayoutParams params1;
                    if (p == position || p == -1 || (params1 = (StaggeredGridLayoutManager.LayoutParams)manager.findViewByPosition(p).getLayoutParams()).getSpanIndex() != spanIndex) continue;
                    return false;
                }
                if (hasBottom) return false;
                return true;
            }
            if (spanIndex != spanCount - 1) return false;
            return true;
        }
        if (!(layoutManager instanceof LinearLayoutManager)) return false;
        return true;
    }

    @Override
    protected void setItemOffsets(Rect outRect, int position, RecyclerView parent) {
        if (this.mPositionInsideItem) {
            outRect.set(0, 0, 0, 0);
            return;
        }
        outRect.set(0, 0, this.getDividerSize(position, parent), 0);
    }

    private int getDividerSize(int position, RecyclerView parent) {
        if (this.mPaintProvider != null) {
            return (int)this.mPaintProvider.dividerPaint(position, parent).getStrokeWidth();
        }
        if (this.mSizeProvider != null) {
            return this.mSizeProvider.dividerSize(position, parent);
        }
        if (this.mDrawableProvider != null) {
            Drawable drawable2 = this.mDrawableProvider.drawableProvider(position, parent);
            return drawable2.getIntrinsicWidth();
        }
        throw new RuntimeException("failed to get size");
    }

    public static class Builder
    extends FlexibleDividerDecoration.Builder<Builder> {
        private MarginProvider mMarginProvider = new MarginProvider(){

            @Override
            public int dividerTopMargin(int position, RecyclerView parent) {
                return 0;
            }

            @Override
            public int dividerBottomMargin(int position, RecyclerView parent) {
                return 0;
            }
        };

        public Builder(Context context) {
            super(context);
        }

        public Builder margin(final int topMargin, final int bottomMargin) {
            return this.marginProvider(new MarginProvider(){

                @Override
                public int dividerTopMargin(int position, RecyclerView parent) {
                    return topMargin;
                }

                @Override
                public int dividerBottomMargin(int position, RecyclerView parent) {
                    return bottomMargin;
                }
            });
        }

        public Builder margin(int verticalMargin) {
            return this.margin(verticalMargin, verticalMargin);
        }

        public Builder marginResId(@DimenRes int topMarginId, @DimenRes int bottomMarginId) {
            return this.margin(this.mResources.getDimensionPixelSize(topMarginId), this.mResources.getDimensionPixelSize(bottomMarginId));
        }

        public Builder marginResId(@DimenRes int verticalMarginId) {
            return this.marginResId(verticalMarginId, verticalMarginId);
        }

        public Builder marginProvider(MarginProvider provider) {
            this.mMarginProvider = provider;
            return this;
        }

        public VerticalDividerItemDecoration build() {
            this.checkBuilderParams();
            return new VerticalDividerItemDecoration(this);
        }
    }

    public static interface MarginProvider {
        public int dividerTopMargin(int var1, RecyclerView var2);

        public int dividerBottomMargin(int var1, RecyclerView var2);
    }
}

