/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.timecounter;

import android.content.Context;
import android.text.format.DateUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.didichuxing.doraemonkit.DoKit;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.timecounter.AppStartInfoFragment;
import com.didichuxing.doraemonkit.kit.timecounter.bean.CounterInfo;
import com.didichuxing.doraemonkit.widget.recyclerview.AbsRecyclerAdapter;
import com.didichuxing.doraemonkit.widget.recyclerview.AbsViewBinder;

public class TimeCounterListAdapter
extends AbsRecyclerAdapter<AbsViewBinder<CounterInfo>, CounterInfo> {
    public TimeCounterListAdapter(Context context) {
        super(context);
    }

    @Override
    protected AbsViewBinder<CounterInfo> createViewHolder(View view, int viewType) {
        return new ItemViewHolder(view);
    }

    @Override
    protected View createView(LayoutInflater inflater, ViewGroup parent, int viewType) {
        return inflater.inflate(R.layout.dk_item_time_counter_list, parent, false);
    }

    private class ItemViewHolder
    extends AbsViewBinder<CounterInfo> {
        private TextView tvTime;
        private TextView tvTitle;
        private TextView tvTotal;
        private TextView tvPause;
        private TextView tvLaunch;
        private TextView tvRender;
        private TextView tvOther;

        public ItemViewHolder(View view) {
            super(view);
        }

        @Override
        protected void getViews() {
            this.tvTime = (TextView)this.getView(R.id.time);
            this.tvTitle = (TextView)this.getView(R.id.title);
            this.tvTotal = (TextView)this.getView(R.id.total_cost);
            this.tvPause = (TextView)this.getView(R.id.pause_cost);
            this.tvLaunch = (TextView)this.getView(R.id.launch_cost);
            this.tvRender = (TextView)this.getView(R.id.render_cost);
            this.tvOther = (TextView)this.getView(R.id.other_cost);
        }

        @Override
        public void bind(CounterInfo counterInfo) {
        }

        @Override
        public void bind(final CounterInfo info, int position) {
            this.tvTitle.setText((CharSequence)info.title);
            String time = DateUtils.formatDateTime((Context)this.getContext(), (long)info.time, (int)1);
            this.tvTime.setText((CharSequence)time);
            this.setTotalCost(info.totalCost);
            this.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    info.show = !info.show;
                    ItemViewHolder.this.showDetail(info);
                    if (info.type == 0 && TimeCounterListAdapter.this.mContext != null) {
                        DoKit.launchFullScreen(AppStartInfoFragment.class, TimeCounterListAdapter.this.mContext);
                    }
                }
            });
            this.showDetail(info);
        }

        private void setTotalCost(long cost) {
            this.tvTotal.setText((CharSequence)("Total Cost: " + cost + "ms"));
            if (cost <= 500L) {
                this.tvTotal.setTextColor(this.getContext().getResources().getColor(R.color.dk_color_48BB31));
            } else if (cost <= 1000L) {
                this.tvTotal.setTextColor(this.getContext().getResources().getColor(R.color.dk_color_FAD337));
            } else {
                this.tvTotal.setTextColor(this.getContext().getResources().getColor(R.color.dk_color_FF0006));
            }
        }

        private void showDetail(CounterInfo info) {
            if (info.type == 0) {
                info.show = false;
            }
            if (info.show) {
                this.tvPause.setVisibility(0);
                this.tvLaunch.setVisibility(0);
                this.tvRender.setVisibility(0);
                this.tvOther.setVisibility(0);
                this.tvPause.setText((CharSequence)("Pause Cost: " + info.pauseCost + "ms"));
                this.tvLaunch.setText((CharSequence)("Launch Cost: " + info.launchCost + "ms"));
                this.tvRender.setText((CharSequence)("Render Cost: " + info.renderCost + "ms"));
                this.tvOther.setText((CharSequence)("Other Cost: " + info.otherCost + "ms"));
            } else {
                this.tvPause.setVisibility(8);
                this.tvLaunch.setVisibility(8);
                this.tvRender.setVisibility(8);
                this.tvOther.setVisibility(8);
            }
        }
    }
}

