/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.timecounter;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.didichuxing.doraemonkit.DoKit;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.aop.method_stack.MethodStackUtil;
import com.didichuxing.doraemonkit.kit.core.BaseFragment;
import com.didichuxing.doraemonkit.util.AppUtils;
import com.didichuxing.doraemonkit.util.DoKitFileUtil;
import com.didichuxing.doraemonkit.util.FileIOUtils;
import com.didichuxing.doraemonkit.util.FileUtils;
import com.didichuxing.doraemonkit.util.PathUtils;
import com.didichuxing.doraemonkit.util.ThreadUtils;
import com.didichuxing.doraemonkit.util.ToastUtils;
import com.didichuxing.doraemonkit.widget.titlebar.TitleBar;
import java.io.File;

public class AppStartInfoFragment
extends BaseFragment {
    TextView mInfo;

    @Override
    protected int onRequestLayout() {
        return R.layout.dk_fragment_app_start_info;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView();
    }

    private void initView() {
        TitleBar titleBar = (TitleBar)((Object)this.findViewById(R.id.title_bar));
        titleBar.setOnTitleBarClickListener(new TitleBar.OnTitleBarClickListener(){

            @Override
            public void onLeftClick() {
                AppStartInfoFragment.this.finish();
            }

            @Override
            public void onRightClick() {
                AppStartInfoFragment.this.export2File(AppStartInfoFragment.this.mInfo.getText().toString());
            }
        });
        this.mInfo = (TextView)this.findViewById(R.id.app_start_info);
        StringBuilder builder = new StringBuilder();
        if (TextUtils.isEmpty((CharSequence)MethodStackUtil.STR_APP_ON_CREATE) && TextUtils.isEmpty((CharSequence)MethodStackUtil.STR_APP_ATTACH_BASECONTEXT)) {
            builder.append("\u53ea\u6709\u914d\u7f6eslowMethod\u7684strategy=0\u6a21\u5f0f\u4e0b\u624d\u80fd\u7edf\u8ba1\u5230\u542f\u52a8\u51fd\u6570\u8c03\u7528\u6808");
        } else {
            if (!TextUtils.isEmpty((CharSequence)MethodStackUtil.STR_APP_ATTACH_BASECONTEXT)) {
                builder.append(MethodStackUtil.STR_APP_ATTACH_BASECONTEXT);
                builder.append("\n");
            }
            builder.append(MethodStackUtil.STR_APP_ON_CREATE);
        }
        this.mInfo.setText((CharSequence)builder.toString());
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    private void export2File(final String info) {
        if (TextUtils.isEmpty((CharSequence)info)) {
            ToastUtils.showShort((CharSequence)"\u542f\u52a8\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        ToastUtils.showShort((CharSequence)"\u542f\u52a8\u4fe1\u606f\u4fdd\u5b58\u4e2d,\u8bf7\u7a0d\u540e...");
        final String logPath = PathUtils.getInternalAppFilesPath() + File.separator + AppUtils.getAppName() + "_app_launch.log";
        final File logFile = new File(logPath);
        ThreadUtils.executeByCpu((ThreadUtils.Task)new ThreadUtils.Task<Boolean>(){

            public Boolean doInBackground() throws Throwable {
                try {
                    FileIOUtils.writeFileFromString((File)logFile, (String)info, (boolean)false);
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }

            public void onSuccess(Boolean result2) {
                if (result2.booleanValue()) {
                    ToastUtils.showShort((CharSequence)("\u542f\u52a8\u4fe1\u606f\u6587\u4ef6\u4fdd\u5b58\u5728:" + logPath));
                    DoKitFileUtil.systemShare((Context)DoKit.APPLICATION, logFile);
                }
            }

            public void onCancel() {
                if (logFile.exists()) {
                    FileUtils.delete((File)logFile);
                }
                ToastUtils.showShort((CharSequence)"\u542f\u52a8\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25");
            }

            public void onFail(Throwable t) {
                if (logFile.exists()) {
                    FileUtils.delete((File)logFile);
                }
                ToastUtils.showShort((CharSequence)"\u542f\u52a8\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25");
            }
        });
    }
}

