/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.performance;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.didichuxing.doraemonkit.kit.performance.PerformanceData;
import com.didichuxing.doraemonkit.kit.performance.PolyLineItemView;
import com.didichuxing.doraemonkit.util.UIUtils;
import java.util.ArrayList;
import java.util.List;

public class PolyLineAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<PerformanceData> data;
    public int maxValue;
    public int minValue;
    public int itemWidth;
    public boolean drawDiver;
    public float pointSize;
    public boolean touchable;
    private boolean showLatestLabel;
    private OnViewClickListener onViewClickListener;

    private PolyLineAdapter() {
    }

    private PolyLineAdapter(List<PerformanceData> data, int maxValue, int minValue, int itemWidth) {
        this.data = data;
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.itemWidth = itemWidth;
    }

    public void setData(List<PerformanceData> d2) {
        if (this.data != null) {
            this.data.clear();
            this.data.addAll(d2);
            this.notifyDataSetChanged();
        }
    }

    public void addData(PerformanceData bean) {
        this.data.add(bean);
        this.notifyDataSetChanged();
    }

    public void addData(List<PerformanceData> beans) {
        this.data.addAll(beans);
        this.notifyDataSetChanged();
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        PolyLineItemView item = new PolyLineItemView(parent.getContext());
        item.setMinValue(this.minValue);
        item.setMaxValue(this.maxValue);
        RecyclerView.LayoutParams layoutParams = new RecyclerView.LayoutParams(this.itemWidth, -1);
        item.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return new ViewHolder(item);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        holder.bindData(position);
    }

    public int getItemCount() {
        return this.data.size();
    }

    public void setOnViewClickListener(OnViewClickListener onViewClickListener) {
        this.onViewClickListener = onViewClickListener;
    }

    public static interface OnViewClickListener {
        public void onViewClick(int var1, PerformanceData var2);
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        PolyLineItemView item;

        public ViewHolder(View itemView) {
            super(itemView);
            this.item = (PolyLineItemView)itemView;
            this.item.setDrawDiver(PolyLineAdapter.this.drawDiver);
            this.item.setPointSize(PolyLineAdapter.this.pointSize);
            this.item.setTouchable(PolyLineAdapter.this.touchable);
        }

        public void bindData(final int position) {
            if (PolyLineAdapter.this.onViewClickListener != null) {
                this.item.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        PolyLineAdapter.this.onViewClickListener.onViewClick(position, (PerformanceData)PolyLineAdapter.this.data.get(position));
                    }
                });
            }
            if (position == 0) {
                this.item.setDrawLeftLine(false);
            } else {
                this.item.setDrawLeftLine(true);
                this.item.setlastValue(((PerformanceData)((PolyLineAdapter)PolyLineAdapter.this).data.get((int)(position - 1))).parameter);
            }
            this.item.setCurrentValue(((PerformanceData)((PolyLineAdapter)PolyLineAdapter.this).data.get((int)position)).parameter);
            this.item.setLabel(((PerformanceData)((PolyLineAdapter)PolyLineAdapter.this).data.get((int)position)).date);
            if (position == PolyLineAdapter.this.data.size() - 1) {
                this.item.setDrawRightLine(false);
            } else {
                this.item.setDrawRightLine(true);
                this.item.setNextValue(((PerformanceData)((PolyLineAdapter)PolyLineAdapter.this).data.get((int)(position + 1))).parameter);
            }
            this.item.showLabel(PolyLineAdapter.this.showLatestLabel && position > PolyLineAdapter.this.data.size() - 3);
        }
    }

    public static class Builder {
        private int maxValue = 100;
        private int minValue = 0;
        private final int itemWidth;
        private List<PerformanceData> data = new ArrayList<PerformanceData>();
        private boolean drawDiver = true;
        private float pointSize;
        private boolean touchable = true;
        private boolean showLatestLabel;

        public Builder(Context context, int itemNumber) {
            this.itemWidth = UIUtils.getWidthPixels() / itemNumber;
        }

        public Builder setMaxValue(int maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public Builder setMinValue(int minValue) {
            this.minValue = minValue;
            return this;
        }

        public Builder setData(List<PerformanceData> data) {
            this.data = data;
            return this;
        }

        public Builder setDrawDiver(boolean drawDiver) {
            this.drawDiver = drawDiver;
            return this;
        }

        public Builder setPointSize(float size) {
            this.pointSize = size;
            return this;
        }

        public PolyLineAdapter build() {
            PolyLineAdapter adapter = new PolyLineAdapter(this.data, this.maxValue, this.minValue, this.itemWidth);
            adapter.drawDiver = this.drawDiver;
            adapter.pointSize = this.pointSize;
            adapter.touchable = this.touchable;
            adapter.showLatestLabel = this.showLatestLabel;
            return adapter;
        }

        public Builder setTouchable(boolean touchable) {
            this.touchable = touchable;
            return this;
        }

        public Builder setShowLatestLabel(boolean showLatestLabel) {
            this.showLatestLabel = showLatestLabel;
            return this;
        }
    }
}

