/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network.ui;

import android.view.ViewGroup;
import android.widget.RadioButton;
import com.didichuxing.doraemonkit.R;
import com.didichuxing.doraemonkit.kit.network.bean.MockApiResponseBean;
import com.didichuxing.doraemonkit.kit.network.room_db.DokitDbManager;
import com.didichuxing.doraemonkit.kit.network.room_db.MockInterceptApiBean;
import com.didichuxing.doraemonkit.widget.MultiLineRadioGroup;
import com.didichuxing.doraemonkit.widget.brvah.entity.node.BaseNode;
import com.didichuxing.doraemonkit.widget.brvah.provider.BaseNodeProvider;
import com.didichuxing.doraemonkit.widget.brvah.viewholder.BaseViewHolder;
import com.didichuxing.doraemonkit.widget.jsonviewer.JsonRecyclerView;
import org.json.JSONException;
import org.json.JSONObject;

public class InterceptDetailNodeProvider
extends BaseNodeProvider {
    @Override
    public int getItemViewType() {
        return 200;
    }

    @Override
    public int getLayoutId() {
        return R.layout.dk_mock_intercept_content_item;
    }

    @Override
    public void convert(BaseViewHolder holder, BaseNode item) {
        if (item instanceof MockInterceptApiBean) {
            JSONObject jsonObject;
            final MockInterceptApiBean mockApi = (MockInterceptApiBean)item;
            holder.setText(R.id.tv_path, "path:" + mockApi.getPath());
            JsonRecyclerView jsonQuery = (JsonRecyclerView)((Object)holder.getView(R.id.jsonviewer_query));
            JsonRecyclerView jsonBody = (JsonRecyclerView)((Object)holder.getView(R.id.jsonviewer_body));
            try {
                holder.getView(R.id.rl_query).setVisibility(0);
                jsonObject = new JSONObject(mockApi.getQuery());
                if (jsonObject.length() == 0) {
                    holder.getView(R.id.rl_query).setVisibility(8);
                } else {
                    jsonQuery.bindJson(mockApi.getQuery());
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
                holder.getView(R.id.rl_query).setVisibility(8);
            }
            try {
                holder.getView(R.id.rl_body).setVisibility(0);
                jsonObject = new JSONObject(mockApi.getBody());
                if (jsonObject.length() == 0) {
                    holder.getView(R.id.rl_body).setVisibility(8);
                } else {
                    jsonBody.bindJson(mockApi.getBody());
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
                holder.getView(R.id.rl_body).setVisibility(8);
            }
            holder.setText(R.id.tv_group, "group:" + mockApi.getGroup());
            holder.setText(R.id.tv_create, "create person:" + mockApi.getCreatePerson());
            holder.setText(R.id.tv_modify, "modify person:" + mockApi.getModifyPerson());
            final MultiLineRadioGroup radioGroup = (MultiLineRadioGroup)((Object)holder.getView(R.id.radio_group));
            if (mockApi.getSceneList() != null && mockApi.getSceneList().size() != 0) {
                int index;
                CharSequence[] radioButtons = new String[mockApi.getSceneList().size()];
                for (index = 0; index < mockApi.getSceneList().size(); ++index) {
                    radioButtons[index] = mockApi.getSceneList().get(index).getName();
                }
                radioGroup.removeAllButtons();
                radioGroup.addButtons(radioButtons);
                radioGroup.setOnCheckedChangeListener(new MultiLineRadioGroup.OnCheckedChangeListener(){

                    @Override
                    public void onCheckedChanged(ViewGroup group, RadioButton button) {
                        int index = radioGroup.getCheckedRadioButtonIndex();
                        MockApiResponseBean.DataBean.DatalistBean.SceneListBean sceneListBean = mockApi.getSceneList().get(index);
                        mockApi.setSelectedSceneName(sceneListBean.getName());
                        mockApi.setSelectedSceneId(sceneListBean.get_id());
                        DokitDbManager.getInstance().updateInterceptApi(mockApi);
                    }
                });
                index = 0;
                for (int i = 0; i < mockApi.getSceneList().size(); ++i) {
                    if (!mockApi.getSceneList().get(i).get_id().equals(mockApi.getSelectedSceneId())) continue;
                    index = i;
                    break;
                }
                radioGroup.checkAt(index);
            }
        }
    }
}

