/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network.okhttp.interceptor;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.didichuxing.doraemonkit.kit.core.DoKitManager;
import com.didichuxing.doraemonkit.kit.network.NetworkManager;
import com.didichuxing.doraemonkit.kit.network.bean.NetworkRecord;
import com.didichuxing.doraemonkit.kit.network.bean.WhiteHostBean;
import com.didichuxing.doraemonkit.kit.network.core.DefaultResponseHandler;
import com.didichuxing.doraemonkit.kit.network.core.NetworkInterpreter;
import com.didichuxing.doraemonkit.kit.network.core.RequestBodyHelper;
import com.didichuxing.doraemonkit.kit.network.okhttp.ForwardingResponseBody;
import com.didichuxing.doraemonkit.kit.network.okhttp.InterceptorUtil;
import com.didichuxing.doraemonkit.kit.network.okhttp.OkHttpInspectorRequest;
import com.didichuxing.doraemonkit.kit.network.okhttp.OkHttpInspectorResponse;
import com.didichuxing.doraemonkit.kit.network.okhttp.interceptor.AbsDoKitInterceptor;
import com.didichuxing.doraemonkit.kit.network.utils.OkHttpResponseKt;
import com.didichuxing.doraemonkit.util.LogHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class DokitCapInterceptor
extends AbsDoKitInterceptor {
    private final NetworkInterpreter mNetworkInterpreter = NetworkInterpreter.get();

    @NonNull
    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        Response response;
        if (!NetworkManager.isActive()) {
            Request request2 = chain.request();
            try {
                return chain.proceed(request2);
            }
            catch (Exception e) {
                ResponseBody responseBody = ResponseBody.create((MediaType)MediaType.parse((String)"application/json;charset=utf-8"), (String)("" + e.getMessage()));
                return new Response.Builder().code(400).message(String.format("%s==>Exception:%s", chain.request().url().host(), e.getMessage())).request(request2).body(responseBody).protocol(Protocol.HTTP_1_1).build();
            }
        }
        Request request3 = chain.request();
        int requestId = this.mNetworkInterpreter.nextRequestId();
        try {
            response = chain.proceed(request3);
        }
        catch (Exception e) {
            LogHelper.e(this.getTAG(), "e===>" + e.getMessage());
            this.mNetworkInterpreter.httpExchangeFailed(requestId, e.toString());
            ResponseBody responseBody = ResponseBody.create((MediaType)MediaType.parse((String)"application/json;charset=utf-8"), (String)("" + e.getMessage()));
            return new Response.Builder().code(400).message(String.format("%s==>Exception:%s", chain.request().url().host(), e.getMessage())).request(request3).body(responseBody).protocol(Protocol.HTTP_1_1).build();
        }
        String strContentType = response.header("Content-Type");
        if (InterceptorUtil.isImg(strContentType)) {
            return response;
        }
        if (!this.matchWhiteHost(request3)) {
            return response;
        }
        RequestBodyHelper requestBodyHelper = new RequestBodyHelper();
        OkHttpInspectorRequest inspectorRequest = new OkHttpInspectorRequest(requestId, request3, requestBodyHelper);
        String platform = "native";
        if (request3.url().toString().contains("dokit_flag")) {
            platform = "web";
        }
        NetworkRecord record = this.mNetworkInterpreter.createRecord(requestId, platform, inspectorRequest);
        OkHttpInspectorResponse inspectorResponse = new OkHttpInspectorResponse(requestId, request3, response);
        this.mNetworkInterpreter.fetchResponseInfo(record, inspectorResponse);
        ResponseBody body = response.body();
        InputStream responseStream = null;
        MediaType contentType = null;
        if (body != null) {
            contentType = body.contentType();
            responseStream = body.byteStream();
        }
        responseStream = this.mNetworkInterpreter.interpretResponseStream(contentType != null ? contentType.toString() : null, responseStream, new DefaultResponseHandler(this.mNetworkInterpreter, requestId, record));
        record.mResponseBody = OkHttpResponseKt.bodyContent(response);
        LogHelper.d("http-monitor", "response body >>>\n" + record.mResponseBody);
        if (responseStream != null) {
            response = response.newBuilder().body((ResponseBody)new ForwardingResponseBody(body, responseStream)).build();
        }
        return response;
    }

    private boolean matchWhiteHost(Request request2) {
        List<WhiteHostBean> whiteHostBeans = DoKitManager.WHITE_HOSTS;
        if (whiteHostBeans.isEmpty()) {
            return true;
        }
        for (WhiteHostBean whiteHostBean : whiteHostBeans) {
            if (TextUtils.isEmpty((CharSequence)whiteHostBean.getHost())) continue;
            String realHost = request2.url().host();
            if (!whiteHostBean.getHost().equalsIgnoreCase(realHost)) continue;
            return true;
        }
        return false;
    }
}

