/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network.core;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.didichuxing.doraemonkit.kit.network.NetworkManager;
import com.didichuxing.doraemonkit.kit.network.bean.NetworkRecord;
import com.didichuxing.doraemonkit.kit.network.bean.Request;
import com.didichuxing.doraemonkit.kit.network.bean.Response;
import com.didichuxing.doraemonkit.kit.network.core.ResourceType;
import com.didichuxing.doraemonkit.kit.network.core.ResourceTypeHelper;
import com.didichuxing.doraemonkit.kit.network.core.ResponseHandler;
import com.didichuxing.doraemonkit.kit.network.stream.InputStreamProxy;
import com.didichuxing.doraemonkit.kit.network.utils.Utf8Charset;
import com.didichuxing.doraemonkit.util.LogHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;

public class NetworkInterpreter {
    public static final String TAG = "NetworkInterpreter";
    private final AtomicInteger mNextRequestId = new AtomicInteger(0);
    private ResourceTypeHelper mResourceTypeHelper;

    public static NetworkInterpreter get() {
        return Holder.INSTANCE;
    }

    public void httpExchangeFailed(int requestId, String s) {
    }

    public void responseReadFinished(int requestId, NetworkRecord record, ByteArrayOutputStream outputStream) {
        if (outputStream != null) {
            record.responseLength = outputStream.size();
            record.mResponseBody = outputStream.toString();
        }
    }

    public void responseReadFailed(int requestId, String s) {
        LogHelper.i(TAG, "[responseReadFailed] requestId: " + requestId + " error: " + s);
    }

    public int nextRequestId() {
        return this.mNextRequestId.getAndIncrement();
    }

    public InputStream interpretResponseStream(String contentType, @Nullable InputStream availableInputStream, ResponseHandler responseHandler) {
        ResourceType resourceType;
        if (availableInputStream == null) {
            responseHandler.onEOF(null);
            return null;
        }
        ResourceType resourceType2 = resourceType = contentType != null ? this.getResourceTypeHelper().determineResourceType(contentType) : null;
        if (resourceType != ResourceType.DOCUMENT && resourceType != ResourceType.XHR) {
            responseHandler.onEOF(null);
            return availableInputStream;
        }
        return new InputStreamProxy(availableInputStream, responseHandler);
    }

    public NetworkRecord createRecord(int requestId, String platform, InspectorRequest request2) {
        NetworkRecord record = new NetworkRecord();
        record.mRequestId = requestId;
        record.mPlatform = platform;
        this.fetchRequestInfo(record, request2);
        NetworkManager.get().addRecord(requestId, record);
        return record;
    }

    private void fetchRequestInfo(NetworkRecord record, InspectorRequest request2) {
        Request requestJSON = new Request();
        requestJSON.url = request2.url();
        requestJSON.method = request2.method();
        requestJSON.headers = this.formatHeadersAsString(request2);
        requestJSON.encode = request2.firstHeaderValue("Content-Encoding");
        requestJSON.postData = this.readBodyAsString(request2);
        record.mRequest = requestJSON;
        record.startTime = System.currentTimeMillis();
        record.requestLength = this.readBodyLength(request2);
    }

    public void fetRequestBody(NetworkRecord record, byte[] request2) {
        if (record.mRequest != null) {
            record.mRequest.postData = this.readBodyAsString(request2);
            record.requestLength = this.readBodyLength(request2);
            NetworkManager.get().updateRecord(record, false);
        }
    }

    public void fetchResponseBody(NetworkRecord record, String body) {
        if (TextUtils.isEmpty((CharSequence)body)) {
            record.responseLength = 0L;
            record.mResponseBody = null;
        } else {
            record.responseLength = body.getBytes().length;
            record.mResponseBody = body;
        }
    }

    public void fetchResponseInfo(NetworkRecord record, InspectorResponse response) {
        Response responseJSON = new Response();
        responseJSON.url = response.url();
        responseJSON.status = response.statusCode();
        responseJSON.headers = this.formatHeadersAsString(response);
        String contentType = this.getContentType(response);
        responseJSON.mimeType = contentType != null ? this.getResourceTypeHelper().stripContentExtras(contentType) : "application/octet-stream";
        record.mResponse = responseJSON;
        record.endTime = System.currentTimeMillis();
        NetworkManager.get().updateRecord(record, false);
    }

    private ResourceTypeHelper getResourceTypeHelper() {
        if (this.mResourceTypeHelper == null) {
            this.mResourceTypeHelper = new ResourceTypeHelper();
        }
        return this.mResourceTypeHelper;
    }

    private String formatHeadersAsString(InspectorHeaders headers) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < headers.headerCount(); ++i) {
            String name = headers.headerName(i);
            String value = headers.headerValue(i);
            builder.append(name + ":" + value);
            if (i == headers.headerCount() - 1) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    private String readBodyAsString(InspectorRequest request2) {
        try {
            byte[] body = request2.body();
            if (body != null) {
                return new String(body, Utf8Charset.INSTANCE);
            }
        }
        catch (IOException | OutOfMemoryError throwable) {
            // empty catch block
        }
        return null;
    }

    private String readBodyAsString(byte[] body) {
        try {
            if (body != null) {
                return new String(body, Utf8Charset.INSTANCE);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        return null;
    }

    private long readBodyLength(InspectorRequest request2) {
        try {
            byte[] body = request2.body();
            if (body != null) {
                return body.length;
            }
        }
        catch (IOException | OutOfMemoryError throwable) {
            // empty catch block
        }
        return 0L;
    }

    private long readBodyLength(byte[] body) {
        try {
            if (body != null) {
                return body.length;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        return 0L;
    }

    private String getContentType(InspectorHeaders headers) {
        return headers.firstHeaderValue("Content-Type");
    }

    public static interface InspectorHeaders {
        public int headerCount();

        public String headerName(int var1);

        public String headerValue(int var1);

        @Nullable
        public String firstHeaderValue(String var1);
    }

    public static interface InspectorResponseCommon
    extends InspectorHeaders {
        public int requestId();

        public int statusCode();
    }

    public static interface InspectorRequestCommon
    extends InspectorHeaders {
        public int id();
    }

    public static interface InspectorResponse
    extends InspectorResponseCommon {
        public String url();
    }

    public static interface InspectorRequest
    extends InspectorRequestCommon {
        public String url();

        public String method();

        @Nullable
        public byte[] body() throws IOException;
    }

    private static class Holder {
        private static NetworkInterpreter INSTANCE = new NetworkInterpreter();

        private Holder() {
        }
    }
}

