/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.network.common;

import androidx.annotation.NonNull;
import com.didichuxing.doraemonkit.kit.network.NetworkManager;
import com.didichuxing.doraemonkit.kit.network.bean.NetworkRecord;
import com.didichuxing.doraemonkit.kit.network.common.CommonInspectorRequest;
import com.didichuxing.doraemonkit.kit.network.common.CommonInspectorResponse;
import com.didichuxing.doraemonkit.kit.network.core.NetworkInterpreter;
import com.didichuxing.doraemonkit.util.LogHelper;

public class NetworkPrinterHelper {
    private static final String TAG = "NetworkLogHelper";
    private final NetworkInterpreter mInterpreter = NetworkInterpreter.get();

    private NetworkPrinterHelper() {
    }

    private static NetworkPrinterHelper get() {
        return Holder.INSTANCE;
    }

    public static int obtainRequestId() {
        return NetworkPrinterHelper.get().mInterpreter.nextRequestId();
    }

    public static void updateRequest(@NonNull CommonInspectorRequest request2) {
        NetworkPrinterHelper.get().mInterpreter.createRecord(request2.id(), "native", request2);
    }

    public static void updateResponse(@NonNull CommonInspectorResponse response) {
        NetworkRecord networkRecord = NetworkManager.get().getRecord(response.requestId());
        if (networkRecord != null) {
            NetworkPrinterHelper.get().mInterpreter.fetchResponseInfo(networkRecord, response);
        } else {
            LogHelper.e(TAG, "updateResponse fail ,record is null for requestId: " + response.requestId());
        }
    }

    public static void updateResponseBody(int requestId, String body) {
        NetworkRecord networkRecord = NetworkManager.get().getRecord(requestId);
        if (networkRecord != null) {
            NetworkPrinterHelper.get().mInterpreter.fetchResponseBody(networkRecord, body);
        } else {
            LogHelper.e(TAG, "updateResponseBody fail ,record is null for requestId: " + requestId);
        }
    }

    private static class Holder {
        private static NetworkPrinterHelper INSTANCE = new NetworkPrinterHelper();

        private Holder() {
        }
    }
}

