/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.loginfo;

import android.text.TextUtils;
import com.didichuxing.doraemonkit.kit.loginfo.reader.ScrubberUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogLine {
    private static final int TIMESTAMP_LENGTH = 19;
    private static Pattern logPattern = Pattern.compile("(\\w)/([^(]+)\\(\\s*(\\d+)(?:\\*\\s*\\d+)?\\): ");
    private static final String filterPattern = "ResourceType|memtrack|android.os.Debug|BufferItemConsumer|DPM.*|MDM.*|ChimeraUtils|BatteryExternalStats.*|chatty.*|DisplayPowerController|WidgetHelper|WearableService|DigitalWidget.*|^ANDR-PERF-.*";
    private int logLevel;
    private String tag;
    private String logOutput;
    private int processId = -1;
    private String timestamp;
    private boolean expanded = false;
    private boolean highlighted = false;
    public static boolean isScrubberEnabled = false;

    public static LogLine newLogLine(String originalLine, boolean expanded) {
        Matcher matcher;
        LogLine logLine = new LogLine();
        logLine.setExpanded(expanded);
        int startIdx = 0;
        if (!TextUtils.isEmpty((CharSequence)originalLine) && Character.isDigit(originalLine.charAt(0)) && originalLine.length() >= 19) {
            String timestamp = originalLine.substring(0, 18);
            logLine.setTimestamp(timestamp);
            startIdx = 19;
        }
        if ((matcher = logPattern.matcher(originalLine)).find(startIdx)) {
            char logLevelChar = matcher.group(1).charAt(0);
            String logText = originalLine.substring(matcher.end());
            if (logText.matches("^maxLineHeight.*|Failed to read.*")) {
                logLine.setLogLevel(LogLine.convertCharToLogLevel('V'));
            } else {
                logLine.setLogLevel(LogLine.convertCharToLogLevel(logLevelChar));
            }
            String tagText = matcher.group(2);
            if (tagText.matches(filterPattern)) {
                logLine.setLogLevel(LogLine.convertCharToLogLevel('V'));
            }
            logLine.setTag(tagText);
            logLine.setProcessId(Integer.parseInt(matcher.group(3)));
            logLine.setLogOutput(logText);
        } else {
            logLine.setLogOutput(originalLine);
            logLine.setLogLevel(-1);
        }
        return logLine;
    }

    private static int convertCharToLogLevel(char logLevelChar) {
        switch (logLevelChar) {
            case 'D': {
                return 3;
            }
            case 'E': {
                return 6;
            }
            case 'I': {
                return 4;
            }
            case 'V': {
                return 2;
            }
            case 'W': {
                return 5;
            }
            case 'F': {
                return 2;
            }
        }
        return -1;
    }

    private static char convertLogLevelToChar(int logLevel) {
        switch (logLevel) {
            case 3: {
                return 'D';
            }
            case 6: {
                return 'E';
            }
            case 4: {
                return 'I';
            }
            case 2: {
                return 'V';
            }
            case 5: {
                return 'W';
            }
        }
        return ' ';
    }

    public String getOriginalLine() {
        if (this.logLevel == -1) {
            return this.logOutput;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.timestamp != null) {
            stringBuilder.append(this.timestamp).append(' ');
        }
        stringBuilder.append(LogLine.convertLogLevelToChar(this.logLevel)).append('/').append(this.tag).append('(').append(this.processId).append("): ").append(this.logOutput);
        return stringBuilder.toString();
    }

    public String getLogLevelText() {
        return Character.toString(LogLine.convertLogLevelToChar(this.logLevel));
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getLogOutput() {
        return this.logOutput;
    }

    public void setLogOutput(String logOutput) {
        this.logOutput = isScrubberEnabled ? ScrubberUtils.scrubLine(logOutput) : logOutput;
    }

    public int getProcessId() {
        return this.processId;
    }

    public void setProcessId(int processId) {
        this.processId = processId;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
    }
}

