/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.loginfo;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import com.didichuxing.doraemonkit.kit.loginfo.LogLine;
import com.didichuxing.doraemonkit.kit.loginfo.reader.LogcatReader;
import com.didichuxing.doraemonkit.kit.loginfo.reader.LogcatReaderLoader;
import com.didichuxing.doraemonkit.util.DoKitExecutorUtil;
import com.didichuxing.doraemonkit.util.LogHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class LogInfoManager {
    private static final String TAG = "LogInfoManager";
    private static final int MESSAGE_PUBLISH_LOG = 1001;
    private OnLogCatchListener mListener;
    private LogCatchRunnable mLogCatchTask;

    private LogInfoManager() {
    }

    public static LogInfoManager getInstance() {
        return Holder.INSTANCE;
    }

    public void start() {
        if (this.mLogCatchTask != null) {
            this.mLogCatchTask.stop();
        }
        this.mLogCatchTask = new LogCatchRunnable();
        DoKitExecutorUtil.execute(this.mLogCatchTask);
    }

    public void stop() {
        if (this.mLogCatchTask != null) {
            this.mLogCatchTask.stop();
        }
    }

    public void registerListener(OnLogCatchListener listener) {
        this.mListener = listener;
    }

    public void removeListener() {
        this.mListener = null;
    }

    private static class LogCatchRunnable
    implements Runnable {
        private boolean isRunning = true;
        private Handler internalHandler = new InternalHandler(Looper.getMainLooper());
        private LogcatReader mReader;
        private int mPid = Process.myPid();

        private LogCatchRunnable() {
        }

        @Override
        public void run() {
            try {
                String line;
                LogcatReaderLoader loader = LogcatReaderLoader.create(true);
                this.mReader = loader.loadReader();
                int maxLines = 10000;
                LinkedList<LogLine> initialLines = new LinkedList<LogLine>();
                while ((line = this.mReader.readLine()) != null && this.isRunning) {
                    Message message;
                    LogLine logLine = LogLine.newLogLine(line, false);
                    if (!this.mReader.readyToRecord()) {
                        if (logLine.getProcessId() == this.mPid) {
                            initialLines.add(logLine);
                        }
                        if (initialLines.size() <= maxLines) continue;
                        initialLines.removeFirst();
                        continue;
                    }
                    if (!initialLines.isEmpty()) {
                        if (logLine.getProcessId() == this.mPid) {
                            initialLines.add(logLine);
                        }
                        message = Message.obtain();
                        message.what = 1001;
                        message.obj = new ArrayList(initialLines);
                        this.internalHandler.sendMessage(message);
                        initialLines.clear();
                        continue;
                    }
                    if (logLine.getProcessId() != this.mPid) continue;
                    message = Message.obtain();
                    message.what = 1001;
                    message.obj = Collections.singletonList(logLine);
                    this.internalHandler.sendMessage(message);
                }
                this.mReader.killQuietly();
            }
            catch (IOException e) {
                LogHelper.e(LogInfoManager.TAG, e.toString());
            }
        }

        public void stop() {
            this.isRunning = false;
        }
    }

    private static class InternalHandler
    extends Handler {
        public InternalHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1001: {
                    if (LogInfoManager.getInstance().mListener == null) break;
                    LogInfoManager.getInstance().mListener.onLogCatch((List)msg.obj);
                    break;
                }
            }
        }
    }

    public static interface OnLogCatchListener {
        public void onLogCatch(List<LogLine> var1);
    }

    private static class Holder {
        private static LogInfoManager INSTANCE = new LogInfoManager();

        private Holder() {
        }
    }
}

