/*
 * Decompiled with CFR 0.152.
 */
package com.didichuxing.doraemonkit.kit.layoutborder;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.didichuxing.doraemonkit.config.LayoutBorderConfig;

public class ViewBorderDrawable
extends Drawable {
    private final Paint paint = new Paint(1);
    private final Rect rect;
    private final Context context;

    public ViewBorderDrawable(View view) {
        this.rect = new Rect(0, 0, view.getWidth(), view.getHeight());
        this.context = view.getContext();
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setColor(-65536);
        this.paint.setStrokeWidth(4.0f);
        this.paint.setPathEffect((PathEffect)new DashPathEffect(new float[]{4.0f, 4.0f}, 0.0f));
    }

    public void draw(@NonNull Canvas canvas) {
        if (LayoutBorderConfig.isLayoutBorderOpen()) {
            canvas.drawRect(this.rect, this.paint);
        }
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -3;
    }
}

